@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The severity for alerts created by this alert rule.
 */
public enum class AlertSeverity(
    public val javaValue: com.pulumi.azurenative.securityinsights.enums.AlertSeverity,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.enums.AlertSeverity> {
    /**
     * High severity
     */
    High(com.pulumi.azurenative.securityinsights.enums.AlertSeverity.High),

    /**
     * Medium severity
     */
    Medium(com.pulumi.azurenative.securityinsights.enums.AlertSeverity.Medium),

    /**
     * Low severity
     */
    Low(com.pulumi.azurenative.securityinsights.enums.AlertSeverity.Low),

    /**
     * Informational severity
     */
    Informational(com.pulumi.azurenative.securityinsights.enums.AlertSeverity.Informational),
    ;

    override fun toJava(): com.pulumi.azurenative.securityinsights.enums.AlertSeverity = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.enums.AlertSeverity): AlertSeverity = AlertSeverity.values().first { it.javaValue == javaType }
    }
}
