@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The property to evaluate in an automation rule property condition.
 */
public enum class AutomationRulePropertyConditionSupportedProperty(
    public val javaValue: com.pulumi.azurenative.securityinsights.enums.AutomationRulePropertyConditionSupportedProperty,
) :
    ConvertibleToJava<com.pulumi.azurenative.securityinsights.enums.AutomationRulePropertyConditionSupportedProperty> {
    /**
     * The title of the incident
     */
    IncidentTitle(com.pulumi.azurenative.securityinsights.enums.AutomationRulePropertyConditionSupportedProperty.IncidentTitle),

    /**
     * The description of the incident
     */
    IncidentDescription(com.pulumi.azurenative.securityinsights.enums.AutomationRulePropertyConditionSupportedProperty.IncidentDescription),

    /**
     * The severity of the incident
     */
    IncidentSeverity(com.pulumi.azurenative.securityinsights.enums.AutomationRulePropertyConditionSupportedProperty.IncidentSeverity),

    /**
     * The status of the incident
     */
    IncidentStatus(com.pulumi.azurenative.securityinsights.enums.AutomationRulePropertyConditionSupportedProperty.IncidentStatus),

    /**
     * The related Analytic rule ids of the incident
     */
    IncidentRelatedAnalyticRuleIds(com.pulumi.azurenative.securityinsights.enums.AutomationRulePropertyConditionSupportedProperty.IncidentRelatedAnalyticRuleIds),

    /**
     * The tactics of the incident
     */
    IncidentTactics(com.pulumi.azurenative.securityinsights.enums.AutomationRulePropertyConditionSupportedProperty.IncidentTactics),

    /**
     * The labels of the incident
     */
    IncidentLabel(com.pulumi.azurenative.securityinsights.enums.AutomationRulePropertyConditionSupportedProperty.IncidentLabel),

    /**
     * The provider name of the incident
     */
    IncidentProviderName(com.pulumi.azurenative.securityinsights.enums.AutomationRulePropertyConditionSupportedProperty.IncidentProviderName),

    /**
     * The update source of the incident
     */
    IncidentUpdatedBySource(com.pulumi.azurenative.securityinsights.enums.AutomationRulePropertyConditionSupportedProperty.IncidentUpdatedBySource),

    /**
     * The account Azure Active Directory tenant id
     */
    AccountAadTenantId(com.pulumi.azurenative.securityinsights.enums.AutomationRulePropertyConditionSupportedProperty.AccountAadTenantId),

    /**
     * The account Azure Active Directory user id
     */
    AccountAadUserId(com.pulumi.azurenative.securityinsights.enums.AutomationRulePropertyConditionSupportedProperty.AccountAadUserId),

    /**
     * The account name
     */
    AccountName(com.pulumi.azurenative.securityinsights.enums.AutomationRulePropertyConditionSupportedProperty.AccountName),

    /**
     * The account NetBIOS domain name
     */
    AccountNTDomain(com.pulumi.azurenative.securityinsights.enums.AutomationRulePropertyConditionSupportedProperty.AccountNTDomain),

    /**
     * The account Azure Active Directory Passport User ID
     */
    AccountPUID(com.pulumi.azurenative.securityinsights.enums.AutomationRulePropertyConditionSupportedProperty.AccountPUID),

    /**
     * The account security identifier
     */
    AccountSid(com.pulumi.azurenative.securityinsights.enums.AutomationRulePropertyConditionSupportedProperty.AccountSid),

    /**
     * The account unique identifier
     */
    AccountObjectGuid(com.pulumi.azurenative.securityinsights.enums.AutomationRulePropertyConditionSupportedProperty.AccountObjectGuid),

    /**
     * The account user principal name suffix
     */
    AccountUPNSuffix(com.pulumi.azurenative.securityinsights.enums.AutomationRulePropertyConditionSupportedProperty.AccountUPNSuffix),

    /**
     * The name of the product of the alert
     */
    AlertProductNames(com.pulumi.azurenative.securityinsights.enums.AutomationRulePropertyConditionSupportedProperty.AlertProductNames),

    /**
     * The analytic rule ids of the alert
     */
    AlertAnalyticRuleIds(com.pulumi.azurenative.securityinsights.enums.AutomationRulePropertyConditionSupportedProperty.AlertAnalyticRuleIds),

    /**
     * The Azure resource id
     */
    AzureResourceResourceId(com.pulumi.azurenative.securityinsights.enums.AutomationRulePropertyConditionSupportedProperty.AzureResourceResourceId),

    /**
     * The Azure resource subscription id
     */
    AzureResourceSubscriptionId(com.pulumi.azurenative.securityinsights.enums.AutomationRulePropertyConditionSupportedProperty.AzureResourceSubscriptionId),

    /**
     * The cloud application identifier
     */
    CloudApplicationAppId(com.pulumi.azurenative.securityinsights.enums.AutomationRulePropertyConditionSupportedProperty.CloudApplicationAppId),

    /**
     * The cloud application name
     */
    CloudApplicationAppName(com.pulumi.azurenative.securityinsights.enums.AutomationRulePropertyConditionSupportedProperty.CloudApplicationAppName),

    /**
     * The dns record domain name
     */
    DNSDomainName(com.pulumi.azurenative.securityinsights.enums.AutomationRulePropertyConditionSupportedProperty.DNSDomainName),

    /**
     * The file directory full path
     */
    FileDirectory(com.pulumi.azurenative.securityinsights.enums.AutomationRulePropertyConditionSupportedProperty.FileDirectory),

    /**
     * The file name without path
     */
    FileName(com.pulumi.azurenative.securityinsights.enums.AutomationRulePropertyConditionSupportedProperty.FileName),

    /**
     * The file hash value
     */
    FileHashValue(com.pulumi.azurenative.securityinsights.enums.AutomationRulePropertyConditionSupportedProperty.FileHashValue),

    /**
     * The host Azure resource id
     */
    HostAzureID(com.pulumi.azurenative.securityinsights.enums.AutomationRulePropertyConditionSupportedProperty.HostAzureID),

    /**
     * The host name without domain
     */
    HostName(com.pulumi.azurenative.securityinsights.enums.AutomationRulePropertyConditionSupportedProperty.HostName),

    /**
     * The host NetBIOS name
     */
    HostNetBiosName(com.pulumi.azurenative.securityinsights.enums.AutomationRulePropertyConditionSupportedProperty.HostNetBiosName),

    /**
     * The host NT domain
     */
    HostNTDomain(com.pulumi.azurenative.securityinsights.enums.AutomationRulePropertyConditionSupportedProperty.HostNTDomain),

    /**
     * The host operating system
     */
    HostOSVersion(com.pulumi.azurenative.securityinsights.enums.AutomationRulePropertyConditionSupportedProperty.HostOSVersion),

    /**
     * "The IoT device id
     */
    IoTDeviceId(com.pulumi.azurenative.securityinsights.enums.AutomationRulePropertyConditionSupportedProperty.IoTDeviceId),

    /**
     * The IoT device name
     */
    IoTDeviceName(com.pulumi.azurenative.securityinsights.enums.AutomationRulePropertyConditionSupportedProperty.IoTDeviceName),

    /**
     * The IoT device type
     */
    IoTDeviceType(com.pulumi.azurenative.securityinsights.enums.AutomationRulePropertyConditionSupportedProperty.IoTDeviceType),

    /**
     * The IoT device vendor
     */
    IoTDeviceVendor(com.pulumi.azurenative.securityinsights.enums.AutomationRulePropertyConditionSupportedProperty.IoTDeviceVendor),

    /**
     * The IoT device model
     */
    IoTDeviceModel(com.pulumi.azurenative.securityinsights.enums.AutomationRulePropertyConditionSupportedProperty.IoTDeviceModel),

    /**
     * The IoT device operating system
     */
    IoTDeviceOperatingSystem(com.pulumi.azurenative.securityinsights.enums.AutomationRulePropertyConditionSupportedProperty.IoTDeviceOperatingSystem),

    /**
     * The IP address
     */
    IPAddress(com.pulumi.azurenative.securityinsights.enums.AutomationRulePropertyConditionSupportedProperty.IPAddress),

    /**
     * The mailbox display name
     */
    MailboxDisplayName(com.pulumi.azurenative.securityinsights.enums.AutomationRulePropertyConditionSupportedProperty.MailboxDisplayName),

    /**
     * The mailbox primary address
     */
    MailboxPrimaryAddress(com.pulumi.azurenative.securityinsights.enums.AutomationRulePropertyConditionSupportedProperty.MailboxPrimaryAddress),

    /**
     * The mailbox user principal name
     */
    MailboxUPN(com.pulumi.azurenative.securityinsights.enums.AutomationRulePropertyConditionSupportedProperty.MailboxUPN),

    /**
     * The mail message delivery action
     */
    MailMessageDeliveryAction(com.pulumi.azurenative.securityinsights.enums.AutomationRulePropertyConditionSupportedProperty.MailMessageDeliveryAction),

    /**
     * The mail message delivery location
     */
    MailMessageDeliveryLocation(com.pulumi.azurenative.securityinsights.enums.AutomationRulePropertyConditionSupportedProperty.MailMessageDeliveryLocation),

    /**
     * The mail message recipient
     */
    MailMessageRecipient(com.pulumi.azurenative.securityinsights.enums.AutomationRulePropertyConditionSupportedProperty.MailMessageRecipient),

    /**
     * The mail message sender IP address
     */
    MailMessageSenderIP(com.pulumi.azurenative.securityinsights.enums.AutomationRulePropertyConditionSupportedProperty.MailMessageSenderIP),

    /**
     * The mail message subject
     */
    MailMessageSubject(com.pulumi.azurenative.securityinsights.enums.AutomationRulePropertyConditionSupportedProperty.MailMessageSubject),

    /**
     * The mail message P1 sender
     */
    MailMessageP1Sender(com.pulumi.azurenative.securityinsights.enums.AutomationRulePropertyConditionSupportedProperty.MailMessageP1Sender),

    /**
     * The mail message P2 sender
     */
    MailMessageP2Sender(com.pulumi.azurenative.securityinsights.enums.AutomationRulePropertyConditionSupportedProperty.MailMessageP2Sender),

    /**
     * The malware category
     */
    MalwareCategory(com.pulumi.azurenative.securityinsights.enums.AutomationRulePropertyConditionSupportedProperty.MalwareCategory),

    /**
     * The malware name
     */
    MalwareName(com.pulumi.azurenative.securityinsights.enums.AutomationRulePropertyConditionSupportedProperty.MalwareName),

    /**
     * The process execution command line
     */
    ProcessCommandLine(com.pulumi.azurenative.securityinsights.enums.AutomationRulePropertyConditionSupportedProperty.ProcessCommandLine),

    /**
     * The process id
     */
    ProcessId(com.pulumi.azurenative.securityinsights.enums.AutomationRulePropertyConditionSupportedProperty.ProcessId),

    /**
     * The registry key path
     */
    RegistryKey(com.pulumi.azurenative.securityinsights.enums.AutomationRulePropertyConditionSupportedProperty.RegistryKey),

    /**
     * The registry key value in string formatted representation
     */
    RegistryValueData(com.pulumi.azurenative.securityinsights.enums.AutomationRulePropertyConditionSupportedProperty.RegistryValueData),

    /**
     * The url
     */
    Url(com.pulumi.azurenative.securityinsights.enums.AutomationRulePropertyConditionSupportedProperty.Url),
    ;

    override fun toJava(): com.pulumi.azurenative.securityinsights.enums.AutomationRulePropertyConditionSupportedProperty = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.enums.AutomationRulePropertyConditionSupportedProperty): AutomationRulePropertyConditionSupportedProperty =
            AutomationRulePropertyConditionSupportedProperty.values().first { it.javaValue == javaType }
    }
}
