@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The V3 type of the mapped entity
 */
public enum class EntityMappingType(
    public val javaValue: com.pulumi.azurenative.securityinsights.enums.EntityMappingType,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.enums.EntityMappingType> {
    /**
     * User account entity type
     */
    Account(com.pulumi.azurenative.securityinsights.enums.EntityMappingType.Account),

    /**
     * Host entity type
     */
    Host(com.pulumi.azurenative.securityinsights.enums.EntityMappingType.Host),

    /**
     * IP address entity type
     */
    IP(com.pulumi.azurenative.securityinsights.enums.EntityMappingType.IP),

    /**
     * Malware entity type
     */
    Malware(com.pulumi.azurenative.securityinsights.enums.EntityMappingType.Malware),

    /**
     * System file entity type
     */
    File(com.pulumi.azurenative.securityinsights.enums.EntityMappingType.File),

    /**
     * Process entity type
     */
    Process(com.pulumi.azurenative.securityinsights.enums.EntityMappingType.Process),

    /**
     * Cloud app entity type
     */
    CloudApplication(com.pulumi.azurenative.securityinsights.enums.EntityMappingType.CloudApplication),

    /**
     * DNS entity type
     */
    DNS(com.pulumi.azurenative.securityinsights.enums.EntityMappingType.DNS),

    /**
     * Azure resource entity type
     */
    AzureResource(com.pulumi.azurenative.securityinsights.enums.EntityMappingType.AzureResource),

    /**
     * File-hash entity type
     */
    FileHash(com.pulumi.azurenative.securityinsights.enums.EntityMappingType.FileHash),

    /**
     * Registry key entity type
     */
    RegistryKey(com.pulumi.azurenative.securityinsights.enums.EntityMappingType.RegistryKey),

    /**
     * Registry value entity type
     */
    RegistryValue(com.pulumi.azurenative.securityinsights.enums.EntityMappingType.RegistryValue),

    /**
     * Security group entity type
     */
    SecurityGroup(com.pulumi.azurenative.securityinsights.enums.EntityMappingType.SecurityGroup),

    /**
     * URL entity type
     */
    URL(com.pulumi.azurenative.securityinsights.enums.EntityMappingType.URL),

    /**
     * Mailbox entity type
     */
    Mailbox(com.pulumi.azurenative.securityinsights.enums.EntityMappingType.Mailbox),

    /**
     * Mail cluster entity type
     */
    MailCluster(com.pulumi.azurenative.securityinsights.enums.EntityMappingType.MailCluster),

    /**
     * Mail message entity type
     */
    MailMessage(com.pulumi.azurenative.securityinsights.enums.EntityMappingType.MailMessage),

    /**
     * Submission mail entity type
     */
    SubmissionMail(com.pulumi.azurenative.securityinsights.enums.EntityMappingType.SubmissionMail),
    ;

    override fun toJava(): com.pulumi.azurenative.securityinsights.enums.EntityMappingType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.enums.EntityMappingType): EntityMappingType = EntityMappingType.values().first { it.javaValue == javaType }
    }
}
