@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The type of the query's source entity
 */
public enum class EntityType(
    public val javaValue: com.pulumi.azurenative.securityinsights.enums.EntityType,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.enums.EntityType> {
    /**
     * Entity represents account in the system.
     */
    Account(com.pulumi.azurenative.securityinsights.enums.EntityType.Account),

    /**
     * Entity represents host in the system.
     */
    Host(com.pulumi.azurenative.securityinsights.enums.EntityType.Host),

    /**
     * Entity represents file in the system.
     */
    File(com.pulumi.azurenative.securityinsights.enums.EntityType.File),

    /**
     * Entity represents azure resource in the system.
     */
    AzureResource(com.pulumi.azurenative.securityinsights.enums.EntityType.AzureResource),

    /**
     * Entity represents cloud application in the system.
     */
    CloudApplication(com.pulumi.azurenative.securityinsights.enums.EntityType.CloudApplication),

    /**
     * Entity represents dns in the system.
     */
    DNS(com.pulumi.azurenative.securityinsights.enums.EntityType.DNS),

    /**
     * Entity represents file hash in the system.
     */
    FileHash(com.pulumi.azurenative.securityinsights.enums.EntityType.FileHash),

    /**
     * Entity represents ip in the system.
     */
    IP(com.pulumi.azurenative.securityinsights.enums.EntityType.IP),

    /**
     * Entity represents malware in the system.
     */
    Malware(com.pulumi.azurenative.securityinsights.enums.EntityType.Malware),

    /**
     * Entity represents process in the system.
     */
    Process(com.pulumi.azurenative.securityinsights.enums.EntityType.Process),

    /**
     * Entity represents registry key in the system.
     */
    RegistryKey(com.pulumi.azurenative.securityinsights.enums.EntityType.RegistryKey),

    /**
     * Entity represents registry value in the system.
     */
    RegistryValue(com.pulumi.azurenative.securityinsights.enums.EntityType.RegistryValue),

    /**
     * Entity represents security group in the system.
     */
    SecurityGroup(com.pulumi.azurenative.securityinsights.enums.EntityType.SecurityGroup),

    /**
     * Entity represents url in the system.
     */
    URL(com.pulumi.azurenative.securityinsights.enums.EntityType.URL),

    /**
     * Entity represents IoT device in the system.
     */
    IoTDevice(com.pulumi.azurenative.securityinsights.enums.EntityType.IoTDevice),

    /**
     * Entity represents security alert in the system.
     */
    SecurityAlert(com.pulumi.azurenative.securityinsights.enums.EntityType.SecurityAlert),

    /**
     * Entity represents HuntingBookmark in the system.
     */
    HuntingBookmark(com.pulumi.azurenative.securityinsights.enums.EntityType.HuntingBookmark),

    /**
     * Entity represents mail cluster in the system.
     */
    MailCluster(com.pulumi.azurenative.securityinsights.enums.EntityType.MailCluster),

    /**
     * Entity represents mail message in the system.
     */
    MailMessage(com.pulumi.azurenative.securityinsights.enums.EntityType.MailMessage),

    /**
     * Entity represents mailbox in the system.
     */
    Mailbox(com.pulumi.azurenative.securityinsights.enums.EntityType.Mailbox),

    /**
     * Entity represents submission mail in the system.
     */
    SubmissionMail(com.pulumi.azurenative.securityinsights.enums.EntityType.SubmissionMail),

    /**
     * Entity represents network interface in the system.
     */
    Nic(com.pulumi.azurenative.securityinsights.enums.EntityType.Nic),
    ;

    override fun toJava(): com.pulumi.azurenative.securityinsights.enums.EntityType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.enums.EntityType): EntityType = EntityType.values().first { it.javaValue == javaType }
    }
}
