@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The reason the incident was closed
 */
public enum class IncidentClassification(
    public val javaValue: com.pulumi.azurenative.securityinsights.enums.IncidentClassification,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.enums.IncidentClassification> {
    /**
     * Incident classification was undetermined
     */
    Undetermined(com.pulumi.azurenative.securityinsights.enums.IncidentClassification.Undetermined),

    /**
     * Incident was true positive
     */
    TruePositive(com.pulumi.azurenative.securityinsights.enums.IncidentClassification.TruePositive),

    /**
     * Incident was benign positive
     */
    BenignPositive(com.pulumi.azurenative.securityinsights.enums.IncidentClassification.BenignPositive),

    /**
     * Incident was false positive
     */
    FalsePositive(com.pulumi.azurenative.securityinsights.enums.IncidentClassification.FalsePositive),
    ;

    override fun toJava(): com.pulumi.azurenative.securityinsights.enums.IncidentClassification =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.enums.IncidentClassification): IncidentClassification = IncidentClassification.values().first { it.javaValue == javaType }
    }
}
