@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The classification reason the incident was closed with
 */
public enum class IncidentClassificationReason(
    public val javaValue: com.pulumi.azurenative.securityinsights.enums.IncidentClassificationReason,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.enums.IncidentClassificationReason> {
    /**
     * Classification reason was suspicious activity
     */
    SuspiciousActivity(com.pulumi.azurenative.securityinsights.enums.IncidentClassificationReason.SuspiciousActivity),

    /**
     * Classification reason was suspicious but expected
     */
    SuspiciousButExpected(com.pulumi.azurenative.securityinsights.enums.IncidentClassificationReason.SuspiciousButExpected),

    /**
     * Classification reason was incorrect alert logic
     */
    IncorrectAlertLogic(com.pulumi.azurenative.securityinsights.enums.IncidentClassificationReason.IncorrectAlertLogic),

    /**
     * Classification reason was inaccurate data
     */
    InaccurateData(com.pulumi.azurenative.securityinsights.enums.IncidentClassificationReason.InaccurateData),
    ;

    override fun toJava(): com.pulumi.azurenative.securityinsights.enums.IncidentClassificationReason = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.enums.IncidentClassificationReason): IncidentClassificationReason =
            IncidentClassificationReason.values().first { it.javaValue == javaType }
    }
}
