@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.AlertDetailsOverrideArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Settings for how to dynamically override alert static details
 * @property alertDescriptionFormat the format containing columns name(s) to override the alert description
 * @property alertDisplayNameFormat the format containing columns name(s) to override the alert name
 * @property alertDynamicProperties List of additional dynamic properties to override
 * @property alertSeverityColumnName the column name to take the alert severity from
 * @property alertTacticsColumnName the column name to take the alert tactics from
 */
public data class AlertDetailsOverrideArgs(
    public val alertDescriptionFormat: Output<String>? = null,
    public val alertDisplayNameFormat: Output<String>? = null,
    public val alertDynamicProperties: Output<List<AlertPropertyMappingArgs>>? = null,
    public val alertSeverityColumnName: Output<String>? = null,
    public val alertTacticsColumnName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.AlertDetailsOverrideArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.inputs.AlertDetailsOverrideArgs =
        com.pulumi.azurenative.securityinsights.inputs.AlertDetailsOverrideArgs.builder()
            .alertDescriptionFormat(alertDescriptionFormat?.applyValue({ args0 -> args0 }))
            .alertDisplayNameFormat(alertDisplayNameFormat?.applyValue({ args0 -> args0 }))
            .alertDynamicProperties(
                alertDynamicProperties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .alertSeverityColumnName(alertSeverityColumnName?.applyValue({ args0 -> args0 }))
            .alertTacticsColumnName(alertTacticsColumnName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AlertDetailsOverrideArgs].
 */
@PulumiTagMarker
public class AlertDetailsOverrideArgsBuilder internal constructor() {
    private var alertDescriptionFormat: Output<String>? = null

    private var alertDisplayNameFormat: Output<String>? = null

    private var alertDynamicProperties: Output<List<AlertPropertyMappingArgs>>? = null

    private var alertSeverityColumnName: Output<String>? = null

    private var alertTacticsColumnName: Output<String>? = null

    /**
     * @param value the format containing columns name(s) to override the alert description
     */
    @JvmName("uljgnvaifrgkqdnq")
    public suspend fun alertDescriptionFormat(`value`: Output<String>) {
        this.alertDescriptionFormat = value
    }

    /**
     * @param value the format containing columns name(s) to override the alert name
     */
    @JvmName("pxamgywjdnukaqur")
    public suspend fun alertDisplayNameFormat(`value`: Output<String>) {
        this.alertDisplayNameFormat = value
    }

    /**
     * @param value List of additional dynamic properties to override
     */
    @JvmName("wmakwjsxwylsxigy")
    public suspend fun alertDynamicProperties(`value`: Output<List<AlertPropertyMappingArgs>>) {
        this.alertDynamicProperties = value
    }

    @JvmName("obcrjjtqxhjycxsa")
    public suspend fun alertDynamicProperties(vararg values: Output<AlertPropertyMappingArgs>) {
        this.alertDynamicProperties = Output.all(values.asList())
    }

    /**
     * @param values List of additional dynamic properties to override
     */
    @JvmName("llbrigaolycwdvro")
    public suspend fun alertDynamicProperties(values: List<Output<AlertPropertyMappingArgs>>) {
        this.alertDynamicProperties = Output.all(values)
    }

    /**
     * @param value the column name to take the alert severity from
     */
    @JvmName("hdhrlpgdpoxnqgvi")
    public suspend fun alertSeverityColumnName(`value`: Output<String>) {
        this.alertSeverityColumnName = value
    }

    /**
     * @param value the column name to take the alert tactics from
     */
    @JvmName("etwroqllcaugerrh")
    public suspend fun alertTacticsColumnName(`value`: Output<String>) {
        this.alertTacticsColumnName = value
    }

    /**
     * @param value the format containing columns name(s) to override the alert description
     */
    @JvmName("fchtgvdlgxkqxrpq")
    public suspend fun alertDescriptionFormat(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alertDescriptionFormat = mapped
    }

    /**
     * @param value the format containing columns name(s) to override the alert name
     */
    @JvmName("fbcdkknvacrpxhir")
    public suspend fun alertDisplayNameFormat(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alertDisplayNameFormat = mapped
    }

    /**
     * @param value List of additional dynamic properties to override
     */
    @JvmName("ehbhnthqpouectws")
    public suspend fun alertDynamicProperties(`value`: List<AlertPropertyMappingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alertDynamicProperties = mapped
    }

    /**
     * @param argument List of additional dynamic properties to override
     */
    @JvmName("fewyvgrmihxxbrvh")
    public suspend fun alertDynamicProperties(argument: List<suspend AlertPropertyMappingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AlertPropertyMappingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.alertDynamicProperties = mapped
    }

    /**
     * @param argument List of additional dynamic properties to override
     */
    @JvmName("utytaoyqeyiygokc")
    public suspend fun alertDynamicProperties(vararg argument: suspend AlertPropertyMappingArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AlertPropertyMappingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.alertDynamicProperties = mapped
    }

    /**
     * @param argument List of additional dynamic properties to override
     */
    @JvmName("xvenqysglinoukbo")
    public suspend fun alertDynamicProperties(argument: suspend AlertPropertyMappingArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(AlertPropertyMappingArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.alertDynamicProperties = mapped
    }

    /**
     * @param values List of additional dynamic properties to override
     */
    @JvmName("sibbsmuvjsmjlijg")
    public suspend fun alertDynamicProperties(vararg values: AlertPropertyMappingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.alertDynamicProperties = mapped
    }

    /**
     * @param value the column name to take the alert severity from
     */
    @JvmName("jnbesifaanqeibbv")
    public suspend fun alertSeverityColumnName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alertSeverityColumnName = mapped
    }

    /**
     * @param value the column name to take the alert tactics from
     */
    @JvmName("ibmnlkrgdghhwiam")
    public suspend fun alertTacticsColumnName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alertTacticsColumnName = mapped
    }

    internal fun build(): AlertDetailsOverrideArgs = AlertDetailsOverrideArgs(
        alertDescriptionFormat = alertDescriptionFormat,
        alertDisplayNameFormat = alertDisplayNameFormat,
        alertDynamicProperties = alertDynamicProperties,
        alertSeverityColumnName = alertSeverityColumnName,
        alertTacticsColumnName = alertTacticsColumnName,
    )
}
