@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.AlertPropertyMappingArgs.builder
import com.pulumi.azurenative.securityinsights.kotlin.enums.AlertProperty
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A single alert property mapping to override
 * @property alertProperty The V3 alert property
 * @property value the column name to use to override this property
 */
public data class AlertPropertyMappingArgs(
    public val alertProperty: Output<Either<String, AlertProperty>>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.AlertPropertyMappingArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.inputs.AlertPropertyMappingArgs =
        com.pulumi.azurenative.securityinsights.inputs.AlertPropertyMappingArgs.builder()
            .alertProperty(
                alertProperty?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AlertPropertyMappingArgs].
 */
@PulumiTagMarker
public class AlertPropertyMappingArgsBuilder internal constructor() {
    private var alertProperty: Output<Either<String, AlertProperty>>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The V3 alert property
     */
    @JvmName("mtlqeplhlxfxqytg")
    public suspend fun alertProperty(`value`: Output<Either<String, AlertProperty>>) {
        this.alertProperty = value
    }

    /**
     * @param value the column name to use to override this property
     */
    @JvmName("uwxageexhxmaxhyf")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The V3 alert property
     */
    @JvmName("mjfowmbcbrmhuedt")
    public suspend fun alertProperty(`value`: Either<String, AlertProperty>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alertProperty = mapped
    }

    /**
     * @param value The V3 alert property
     */
    @JvmName("alufujvcvoskswtb")
    public fun alertProperty(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AlertProperty>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.alertProperty = mapped
    }

    /**
     * @param value The V3 alert property
     */
    @JvmName("pgjwuoggcbqdqnju")
    public fun alertProperty(`value`: AlertProperty) {
        val toBeMapped = Either.ofRight<String, AlertProperty>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.alertProperty = mapped
    }

    /**
     * @param value the column name to use to override this property
     */
    @JvmName("onbjjcotyowfocio")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): AlertPropertyMappingArgs = AlertPropertyMappingArgs(
        alertProperty = alertProperty,
        `value` = `value`,
    )
}
