@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.AlertsDataTypeOfDataConnectorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Alerts data type for data connectors.
 * @property alerts Alerts data type connection.
 */
public data class AlertsDataTypeOfDataConnectorArgs(
    public val alerts: Output<DataConnectorDataTypeCommonArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.AlertsDataTypeOfDataConnectorArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.inputs.AlertsDataTypeOfDataConnectorArgs =
        com.pulumi.azurenative.securityinsights.inputs.AlertsDataTypeOfDataConnectorArgs.builder()
            .alerts(alerts?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [AlertsDataTypeOfDataConnectorArgs].
 */
@PulumiTagMarker
public class AlertsDataTypeOfDataConnectorArgsBuilder internal constructor() {
    private var alerts: Output<DataConnectorDataTypeCommonArgs>? = null

    /**
     * @param value Alerts data type connection.
     */
    @JvmName("mxstjtplkbworfpc")
    public suspend fun alerts(`value`: Output<DataConnectorDataTypeCommonArgs>) {
        this.alerts = value
    }

    /**
     * @param value Alerts data type connection.
     */
    @JvmName("yhjlwgxgocmexfwl")
    public suspend fun alerts(`value`: DataConnectorDataTypeCommonArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alerts = mapped
    }

    /**
     * @param argument Alerts data type connection.
     */
    @JvmName("vmdtkppfcbubjlwl")
    public suspend fun alerts(argument: suspend DataConnectorDataTypeCommonArgsBuilder.() -> Unit) {
        val toBeMapped = DataConnectorDataTypeCommonArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.alerts = mapped
    }

    internal fun build(): AlertsDataTypeOfDataConnectorArgs = AlertsDataTypeOfDataConnectorArgs(
        alerts = alerts,
    )
}
