@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.AutomationRuleRunPlaybookActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Describes an automation rule action to run a playbook
 * @property actionConfiguration
 * @property actionType The type of the automation rule action.
 * Expected value is 'RunPlaybook'.
 * @property order
 */
public data class AutomationRuleRunPlaybookActionArgs(
    public val actionConfiguration: Output<PlaybookActionPropertiesArgs>? = null,
    public val actionType: Output<String>,
    public val order: Output<Int>,
) :
    ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.AutomationRuleRunPlaybookActionArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.inputs.AutomationRuleRunPlaybookActionArgs =
        com.pulumi.azurenative.securityinsights.inputs.AutomationRuleRunPlaybookActionArgs.builder()
            .actionConfiguration(
                actionConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .actionType(actionType.applyValue({ args0 -> args0 }))
            .order(order.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AutomationRuleRunPlaybookActionArgs].
 */
@PulumiTagMarker
public class AutomationRuleRunPlaybookActionArgsBuilder internal constructor() {
    private var actionConfiguration: Output<PlaybookActionPropertiesArgs>? = null

    private var actionType: Output<String>? = null

    private var order: Output<Int>? = null

    /**
     * @param value
     */
    @JvmName("emasaouvolignkxv")
    public suspend fun actionConfiguration(`value`: Output<PlaybookActionPropertiesArgs>) {
        this.actionConfiguration = value
    }

    /**
     * @param value The type of the automation rule action.
     * Expected value is 'RunPlaybook'.
     */
    @JvmName("bshrxwkjqgutisvh")
    public suspend fun actionType(`value`: Output<String>) {
        this.actionType = value
    }

    /**
     * @param value
     */
    @JvmName("dmnguhxjdysyjrwu")
    public suspend fun order(`value`: Output<Int>) {
        this.order = value
    }

    /**
     * @param value
     */
    @JvmName("wpkykshwyuxeyepm")
    public suspend fun actionConfiguration(`value`: PlaybookActionPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.actionConfiguration = mapped
    }

    /**
     * @param argument
     */
    @JvmName("wpxbqkgfpphgawgx")
    public suspend fun actionConfiguration(argument: suspend PlaybookActionPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = PlaybookActionPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.actionConfiguration = mapped
    }

    /**
     * @param value The type of the automation rule action.
     * Expected value is 'RunPlaybook'.
     */
    @JvmName("mgtqcvwrcynrfdro")
    public suspend fun actionType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actionType = mapped
    }

    /**
     * @param value
     */
    @JvmName("iwnaolnkwercvjgq")
    public suspend fun order(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.order = mapped
    }

    internal fun build(): AutomationRuleRunPlaybookActionArgs = AutomationRuleRunPlaybookActionArgs(
        actionConfiguration = actionConfiguration,
        actionType = actionType ?: throw PulumiNullFieldException("actionType"),
        order = order ?: throw PulumiNullFieldException("order"),
    )
}
