@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.AzureDevOpsResourceInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Resources created in Azure DevOps repository.
 * @property pipelineId Id of the pipeline created for the source-control.
 * @property serviceConnectionId Id of the service-connection created for the source-control.
 */
public data class AzureDevOpsResourceInfoArgs(
    public val pipelineId: Output<String>? = null,
    public val serviceConnectionId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.AzureDevOpsResourceInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.inputs.AzureDevOpsResourceInfoArgs = com.pulumi.azurenative.securityinsights.inputs.AzureDevOpsResourceInfoArgs.builder()
        .pipelineId(pipelineId?.applyValue({ args0 -> args0 }))
        .serviceConnectionId(serviceConnectionId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureDevOpsResourceInfoArgs].
 */
@PulumiTagMarker
public class AzureDevOpsResourceInfoArgsBuilder internal constructor() {
    private var pipelineId: Output<String>? = null

    private var serviceConnectionId: Output<String>? = null

    /**
     * @param value Id of the pipeline created for the source-control.
     */
    @JvmName("hhbwhpawixlgmvjl")
    public suspend fun pipelineId(`value`: Output<String>) {
        this.pipelineId = value
    }

    /**
     * @param value Id of the service-connection created for the source-control.
     */
    @JvmName("dqaabfnwqooidfhw")
    public suspend fun serviceConnectionId(`value`: Output<String>) {
        this.serviceConnectionId = value
    }

    /**
     * @param value Id of the pipeline created for the source-control.
     */
    @JvmName("uewtghxrfrkjipmk")
    public suspend fun pipelineId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pipelineId = mapped
    }

    /**
     * @param value Id of the service-connection created for the source-control.
     */
    @JvmName("xvqofapinhheiuxh")
    public suspend fun serviceConnectionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceConnectionId = mapped
    }

    internal fun build(): AzureDevOpsResourceInfoArgs = AzureDevOpsResourceInfoArgs(
        pipelineId = pipelineId,
        serviceConnectionId = serviceConnectionId,
    )
}
