@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.ClientInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Information on the client (user or application) that made some action
 * @property email The email of the client.
 * @property name The name of the client.
 * @property objectId The object id of the client.
 * @property userPrincipalName The user principal name of the client.
 */
public data class ClientInfoArgs(
    public val email: Output<String>? = null,
    public val name: Output<String>? = null,
    public val objectId: Output<String>? = null,
    public val userPrincipalName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.ClientInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.inputs.ClientInfoArgs =
        com.pulumi.azurenative.securityinsights.inputs.ClientInfoArgs.builder()
            .email(email?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .objectId(objectId?.applyValue({ args0 -> args0 }))
            .userPrincipalName(userPrincipalName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClientInfoArgs].
 */
@PulumiTagMarker
public class ClientInfoArgsBuilder internal constructor() {
    private var email: Output<String>? = null

    private var name: Output<String>? = null

    private var objectId: Output<String>? = null

    private var userPrincipalName: Output<String>? = null

    /**
     * @param value The email of the client.
     */
    @JvmName("ycgvfekvqudqylpi")
    public suspend fun email(`value`: Output<String>) {
        this.email = value
    }

    /**
     * @param value The name of the client.
     */
    @JvmName("ptdwwlfcnjbutwnu")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The object id of the client.
     */
    @JvmName("luwhnkajarslwlnp")
    public suspend fun objectId(`value`: Output<String>) {
        this.objectId = value
    }

    /**
     * @param value The user principal name of the client.
     */
    @JvmName("aqrwcungakbqwsrp")
    public suspend fun userPrincipalName(`value`: Output<String>) {
        this.userPrincipalName = value
    }

    /**
     * @param value The email of the client.
     */
    @JvmName("ytgbbonvsrkwgmjv")
    public suspend fun email(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.email = mapped
    }

    /**
     * @param value The name of the client.
     */
    @JvmName("bvglcfovoybdohuj")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The object id of the client.
     */
    @JvmName("kxegwvfaftnkipck")
    public suspend fun objectId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.objectId = mapped
    }

    /**
     * @param value The user principal name of the client.
     */
    @JvmName("aimwvrmqcwryhovf")
    public suspend fun userPrincipalName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userPrincipalName = mapped
    }

    internal fun build(): ClientInfoArgs = ClientInfoArgs(
        email = email,
        name = name,
        objectId = objectId,
        userPrincipalName = userPrincipalName,
    )
}
