@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.DeploymentArgs.builder
import com.pulumi.azurenative.securityinsights.kotlin.enums.DeploymentResult
import com.pulumi.azurenative.securityinsights.kotlin.enums.DeploymentState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Description about a deployment.
 * @property deploymentId Deployment identifier.
 * @property deploymentLogsUrl Url to access repository action logs.
 * @property deploymentResult The outcome of the deployment.
 * @property deploymentState Current status of the deployment.
 * @property deploymentTime The time when the deployment finished.
 */
public data class DeploymentArgs(
    public val deploymentId: Output<String>? = null,
    public val deploymentLogsUrl: Output<String>? = null,
    public val deploymentResult: Output<Either<String, DeploymentResult>>? = null,
    public val deploymentState: Output<Either<String, DeploymentState>>? = null,
    public val deploymentTime: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.DeploymentArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.inputs.DeploymentArgs =
        com.pulumi.azurenative.securityinsights.inputs.DeploymentArgs.builder()
            .deploymentId(deploymentId?.applyValue({ args0 -> args0 }))
            .deploymentLogsUrl(deploymentLogsUrl?.applyValue({ args0 -> args0 }))
            .deploymentResult(
                deploymentResult?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .deploymentState(
                deploymentState?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .deploymentTime(deploymentTime?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DeploymentArgs].
 */
@PulumiTagMarker
public class DeploymentArgsBuilder internal constructor() {
    private var deploymentId: Output<String>? = null

    private var deploymentLogsUrl: Output<String>? = null

    private var deploymentResult: Output<Either<String, DeploymentResult>>? = null

    private var deploymentState: Output<Either<String, DeploymentState>>? = null

    private var deploymentTime: Output<String>? = null

    /**
     * @param value Deployment identifier.
     */
    @JvmName("cvpmvehbiyvhrtel")
    public suspend fun deploymentId(`value`: Output<String>) {
        this.deploymentId = value
    }

    /**
     * @param value Url to access repository action logs.
     */
    @JvmName("enyiagejcrlctwor")
    public suspend fun deploymentLogsUrl(`value`: Output<String>) {
        this.deploymentLogsUrl = value
    }

    /**
     * @param value The outcome of the deployment.
     */
    @JvmName("nqcqfwnhhveblaja")
    public suspend fun deploymentResult(`value`: Output<Either<String, DeploymentResult>>) {
        this.deploymentResult = value
    }

    /**
     * @param value Current status of the deployment.
     */
    @JvmName("dhvtqenbgmjgrgsy")
    public suspend fun deploymentState(`value`: Output<Either<String, DeploymentState>>) {
        this.deploymentState = value
    }

    /**
     * @param value The time when the deployment finished.
     */
    @JvmName("auksfkglhihdwock")
    public suspend fun deploymentTime(`value`: Output<String>) {
        this.deploymentTime = value
    }

    /**
     * @param value Deployment identifier.
     */
    @JvmName("ifplgnqfqibkrwve")
    public suspend fun deploymentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentId = mapped
    }

    /**
     * @param value Url to access repository action logs.
     */
    @JvmName("emspeoqneiawxtbw")
    public suspend fun deploymentLogsUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentLogsUrl = mapped
    }

    /**
     * @param value The outcome of the deployment.
     */
    @JvmName("hayywrbapmtmsfno")
    public suspend fun deploymentResult(`value`: Either<String, DeploymentResult>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentResult = mapped
    }

    /**
     * @param value The outcome of the deployment.
     */
    @JvmName("obhglrcqwhxlwdqm")
    public fun deploymentResult(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DeploymentResult>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deploymentResult = mapped
    }

    /**
     * @param value The outcome of the deployment.
     */
    @JvmName("eryxyapvbftmpnug")
    public fun deploymentResult(`value`: DeploymentResult) {
        val toBeMapped = Either.ofRight<String, DeploymentResult>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deploymentResult = mapped
    }

    /**
     * @param value Current status of the deployment.
     */
    @JvmName("tplbushmxsjhnavh")
    public suspend fun deploymentState(`value`: Either<String, DeploymentState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentState = mapped
    }

    /**
     * @param value Current status of the deployment.
     */
    @JvmName("heymluvbygerhhgn")
    public fun deploymentState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DeploymentState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deploymentState = mapped
    }

    /**
     * @param value Current status of the deployment.
     */
    @JvmName("kiiluqfmjsfuivkj")
    public fun deploymentState(`value`: DeploymentState) {
        val toBeMapped = Either.ofRight<String, DeploymentState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deploymentState = mapped
    }

    /**
     * @param value The time when the deployment finished.
     */
    @JvmName("wcvimjcjyywstjuh")
    public suspend fun deploymentTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentTime = mapped
    }

    internal fun build(): DeploymentArgs = DeploymentArgs(
        deploymentId = deploymentId,
        deploymentLogsUrl = deploymentLogsUrl,
        deploymentResult = deploymentResult,
        deploymentState = deploymentState,
        deploymentTime = deploymentTime,
    )
}
