@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.DeploymentInfoArgs.builder
import com.pulumi.azurenative.securityinsights.kotlin.enums.DeploymentFetchStatus
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Information regarding a deployment.
 * @property deployment Deployment information.
 * @property deploymentFetchStatus Status while fetching the last deployment.
 * @property message Additional details about the deployment that can be shown to the user.
 */
public data class DeploymentInfoArgs(
    public val deployment: Output<DeploymentArgs>? = null,
    public val deploymentFetchStatus: Output<Either<String, DeploymentFetchStatus>>? = null,
    public val message: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.DeploymentInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.inputs.DeploymentInfoArgs =
        com.pulumi.azurenative.securityinsights.inputs.DeploymentInfoArgs.builder()
            .deployment(deployment?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .deploymentFetchStatus(
                deploymentFetchStatus?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .message(message?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DeploymentInfoArgs].
 */
@PulumiTagMarker
public class DeploymentInfoArgsBuilder internal constructor() {
    private var deployment: Output<DeploymentArgs>? = null

    private var deploymentFetchStatus: Output<Either<String, DeploymentFetchStatus>>? = null

    private var message: Output<String>? = null

    /**
     * @param value Deployment information.
     */
    @JvmName("ixluotfmltukgcdh")
    public suspend fun deployment(`value`: Output<DeploymentArgs>) {
        this.deployment = value
    }

    /**
     * @param value Status while fetching the last deployment.
     */
    @JvmName("apmmgujgetubeflj")
    public suspend fun deploymentFetchStatus(`value`: Output<Either<String, DeploymentFetchStatus>>) {
        this.deploymentFetchStatus = value
    }

    /**
     * @param value Additional details about the deployment that can be shown to the user.
     */
    @JvmName("daqbnrpohvsvfvfh")
    public suspend fun message(`value`: Output<String>) {
        this.message = value
    }

    /**
     * @param value Deployment information.
     */
    @JvmName("qftpxawqdlqwagci")
    public suspend fun deployment(`value`: DeploymentArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deployment = mapped
    }

    /**
     * @param argument Deployment information.
     */
    @JvmName("xybvqyywjrgqeqdw")
    public suspend fun deployment(argument: suspend DeploymentArgsBuilder.() -> Unit) {
        val toBeMapped = DeploymentArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.deployment = mapped
    }

    /**
     * @param value Status while fetching the last deployment.
     */
    @JvmName("rwenuaxvsvdgosal")
    public suspend fun deploymentFetchStatus(`value`: Either<String, DeploymentFetchStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentFetchStatus = mapped
    }

    /**
     * @param value Status while fetching the last deployment.
     */
    @JvmName("itqehnpuygxgxhyp")
    public fun deploymentFetchStatus(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DeploymentFetchStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deploymentFetchStatus = mapped
    }

    /**
     * @param value Status while fetching the last deployment.
     */
    @JvmName("nvfrlxeghnkpdcdh")
    public fun deploymentFetchStatus(`value`: DeploymentFetchStatus) {
        val toBeMapped = Either.ofRight<String, DeploymentFetchStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deploymentFetchStatus = mapped
    }

    /**
     * @param value Additional details about the deployment that can be shown to the user.
     */
    @JvmName("iegbfovrxfxpicbo")
    public suspend fun message(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.message = mapped
    }

    internal fun build(): DeploymentInfoArgs = DeploymentInfoArgs(
        deployment = deployment,
        deploymentFetchStatus = deploymentFetchStatus,
        message = message,
    )
}
