@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.FileMetadataArgs.builder
import com.pulumi.azurenative.securityinsights.kotlin.enums.FileFormat
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Represents a file.
 * @property fileFormat The format of the file
 * @property fileName The name of the file.
 * @property fileSize The size of the file.
 */
public data class FileMetadataArgs(
    public val fileFormat: Output<Either<String, FileFormat>>? = null,
    public val fileName: Output<String>? = null,
    public val fileSize: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.FileMetadataArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.inputs.FileMetadataArgs =
        com.pulumi.azurenative.securityinsights.inputs.FileMetadataArgs.builder()
            .fileFormat(
                fileFormat?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .fileName(fileName?.applyValue({ args0 -> args0 }))
            .fileSize(fileSize?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FileMetadataArgs].
 */
@PulumiTagMarker
public class FileMetadataArgsBuilder internal constructor() {
    private var fileFormat: Output<Either<String, FileFormat>>? = null

    private var fileName: Output<String>? = null

    private var fileSize: Output<Int>? = null

    /**
     * @param value The format of the file
     */
    @JvmName("htladkssaatcvota")
    public suspend fun fileFormat(`value`: Output<Either<String, FileFormat>>) {
        this.fileFormat = value
    }

    /**
     * @param value The name of the file.
     */
    @JvmName("gdvvchqhrnrojatx")
    public suspend fun fileName(`value`: Output<String>) {
        this.fileName = value
    }

    /**
     * @param value The size of the file.
     */
    @JvmName("ukwquigpetevuwus")
    public suspend fun fileSize(`value`: Output<Int>) {
        this.fileSize = value
    }

    /**
     * @param value The format of the file
     */
    @JvmName("kawrxmamvnhkqfep")
    public suspend fun fileFormat(`value`: Either<String, FileFormat>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileFormat = mapped
    }

    /**
     * @param value The format of the file
     */
    @JvmName("plamxalyxhtwsdqp")
    public fun fileFormat(`value`: String) {
        val toBeMapped = Either.ofLeft<String, FileFormat>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fileFormat = mapped
    }

    /**
     * @param value The format of the file
     */
    @JvmName("fvjmxsmsgmdylpgu")
    public fun fileFormat(`value`: FileFormat) {
        val toBeMapped = Either.ofRight<String, FileFormat>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fileFormat = mapped
    }

    /**
     * @param value The name of the file.
     */
    @JvmName("jcnkdkceunbxtauc")
    public suspend fun fileName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileName = mapped
    }

    /**
     * @param value The size of the file.
     */
    @JvmName("btwdgpxnapjyapvr")
    public suspend fun fileSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileSize = mapped
    }

    internal fun build(): FileMetadataArgs = FileMetadataArgs(
        fileFormat = fileFormat,
        fileName = fileName,
        fileSize = fileSize,
    )
}
