@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.GetBookmarkRelationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property bookmarkId Bookmark ID
 * @property relationName Relation Name
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property workspaceName The name of the workspace.
 */
public data class GetBookmarkRelationPlainArgs(
    public val bookmarkId: String,
    public val relationName: String,
    public val resourceGroupName: String,
    public val workspaceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.GetBookmarkRelationPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.inputs.GetBookmarkRelationPlainArgs = com.pulumi.azurenative.securityinsights.inputs.GetBookmarkRelationPlainArgs.builder()
        .bookmarkId(bookmarkId.let({ args0 -> args0 }))
        .relationName(relationName.let({ args0 -> args0 }))
        .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
        .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetBookmarkRelationPlainArgs].
 */
@PulumiTagMarker
public class GetBookmarkRelationPlainArgsBuilder internal constructor() {
    private var bookmarkId: String? = null

    private var relationName: String? = null

    private var resourceGroupName: String? = null

    private var workspaceName: String? = null

    /**
     * @param value Bookmark ID
     */
    @JvmName("nmmoflxsfqwtynoi")
    public suspend fun bookmarkId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.bookmarkId = mapped
    }

    /**
     * @param value Relation Name
     */
    @JvmName("gcboowclpglesnlv")
    public suspend fun relationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.relationName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xhhokbycnmoqnlbg")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("hlpmtduwvyoanaml")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): GetBookmarkRelationPlainArgs = GetBookmarkRelationPlainArgs(
        bookmarkId = bookmarkId ?: throw PulumiNullFieldException("bookmarkId"),
        relationName = relationName ?: throw PulumiNullFieldException("relationName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
    )
}
