@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.GetFusionAlertRulePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property ruleId Alert rule ID
 * @property workspaceName The name of the workspace.
 */
public data class GetFusionAlertRulePlainArgs(
    public val resourceGroupName: String,
    public val ruleId: String,
    public val workspaceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.GetFusionAlertRulePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.inputs.GetFusionAlertRulePlainArgs = com.pulumi.azurenative.securityinsights.inputs.GetFusionAlertRulePlainArgs.builder()
        .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
        .ruleId(ruleId.let({ args0 -> args0 }))
        .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetFusionAlertRulePlainArgs].
 */
@PulumiTagMarker
public class GetFusionAlertRulePlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var ruleId: String? = null

    private var workspaceName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ocoivxmuedjgyyfo")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Alert rule ID
     */
    @JvmName("epkmexcnhjrylipe")
    public suspend fun ruleId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ruleId = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("gpytjtbjdyeduqmk")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): GetFusionAlertRulePlainArgs = GetFusionAlertRulePlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        ruleId = ruleId ?: throw PulumiNullFieldException("ruleId"),
        workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
    )
}
