@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.GraphQueryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The graph query to show the volume of data arriving into the workspace over time.
 * @property baseQuery Gets or sets the base query for the graph.
 * The base query is wrapped by Sentinel UI infra with a KQL query, that measures the volume over time.
 * @property legend Gets or sets the legend for the graph.
 * @property metricName Gets or sets the metric name that the query is checking. For example: 'Total data receive'.
 */
public data class GraphQueryArgs(
    public val baseQuery: Output<String>,
    public val legend: Output<String>,
    public val metricName: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.GraphQueryArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.inputs.GraphQueryArgs =
        com.pulumi.azurenative.securityinsights.inputs.GraphQueryArgs.builder()
            .baseQuery(baseQuery.applyValue({ args0 -> args0 }))
            .legend(legend.applyValue({ args0 -> args0 }))
            .metricName(metricName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GraphQueryArgs].
 */
@PulumiTagMarker
public class GraphQueryArgsBuilder internal constructor() {
    private var baseQuery: Output<String>? = null

    private var legend: Output<String>? = null

    private var metricName: Output<String>? = null

    /**
     * @param value Gets or sets the base query for the graph.
     * The base query is wrapped by Sentinel UI infra with a KQL query, that measures the volume over time.
     */
    @JvmName("asdpshmexbbmfopi")
    public suspend fun baseQuery(`value`: Output<String>) {
        this.baseQuery = value
    }

    /**
     * @param value Gets or sets the legend for the graph.
     */
    @JvmName("tcygystasggxdqqu")
    public suspend fun legend(`value`: Output<String>) {
        this.legend = value
    }

    /**
     * @param value Gets or sets the metric name that the query is checking. For example: 'Total data receive'.
     */
    @JvmName("icuctdbbimuqccrc")
    public suspend fun metricName(`value`: Output<String>) {
        this.metricName = value
    }

    /**
     * @param value Gets or sets the base query for the graph.
     * The base query is wrapped by Sentinel UI infra with a KQL query, that measures the volume over time.
     */
    @JvmName("dpxnfofakavkpyxo")
    public suspend fun baseQuery(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.baseQuery = mapped
    }

    /**
     * @param value Gets or sets the legend for the graph.
     */
    @JvmName("yawcctwpvjlpstwp")
    public suspend fun legend(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.legend = mapped
    }

    /**
     * @param value Gets or sets the metric name that the query is checking. For example: 'Total data receive'.
     */
    @JvmName("qkjcfblnwocvikgr")
    public suspend fun metricName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metricName = mapped
    }

    internal fun build(): GraphQueryArgs = GraphQueryArgs(
        baseQuery = baseQuery ?: throw PulumiNullFieldException("baseQuery"),
        legend = legend ?: throw PulumiNullFieldException("legend"),
        metricName = metricName ?: throw PulumiNullFieldException("metricName"),
    )
}
