@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.IncidentInfoArgs.builder
import com.pulumi.azurenative.securityinsights.kotlin.enums.IncidentSeverity
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes related incident information for the bookmark
 * @property incidentId Incident Id
 * @property relationName Relation Name
 * @property severity The severity of the incident
 * @property title The title of the incident
 */
public data class IncidentInfoArgs(
    public val incidentId: Output<String>? = null,
    public val relationName: Output<String>? = null,
    public val severity: Output<Either<String, IncidentSeverity>>? = null,
    public val title: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.IncidentInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.inputs.IncidentInfoArgs =
        com.pulumi.azurenative.securityinsights.inputs.IncidentInfoArgs.builder()
            .incidentId(incidentId?.applyValue({ args0 -> args0 }))
            .relationName(relationName?.applyValue({ args0 -> args0 }))
            .severity(
                severity?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .title(title?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IncidentInfoArgs].
 */
@PulumiTagMarker
public class IncidentInfoArgsBuilder internal constructor() {
    private var incidentId: Output<String>? = null

    private var relationName: Output<String>? = null

    private var severity: Output<Either<String, IncidentSeverity>>? = null

    private var title: Output<String>? = null

    /**
     * @param value Incident Id
     */
    @JvmName("lpbkqcljfklqbdcb")
    public suspend fun incidentId(`value`: Output<String>) {
        this.incidentId = value
    }

    /**
     * @param value Relation Name
     */
    @JvmName("iheddfullsalvwld")
    public suspend fun relationName(`value`: Output<String>) {
        this.relationName = value
    }

    /**
     * @param value The severity of the incident
     */
    @JvmName("mskbrwrmkhywoogn")
    public suspend fun severity(`value`: Output<Either<String, IncidentSeverity>>) {
        this.severity = value
    }

    /**
     * @param value The title of the incident
     */
    @JvmName("jweuvrisbqilfsat")
    public suspend fun title(`value`: Output<String>) {
        this.title = value
    }

    /**
     * @param value Incident Id
     */
    @JvmName("cuypmgvmhmpdqfvm")
    public suspend fun incidentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.incidentId = mapped
    }

    /**
     * @param value Relation Name
     */
    @JvmName("vgispvfhxevevakr")
    public suspend fun relationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.relationName = mapped
    }

    /**
     * @param value The severity of the incident
     */
    @JvmName("qjoxtsocmgxumgbu")
    public suspend fun severity(`value`: Either<String, IncidentSeverity>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.severity = mapped
    }

    /**
     * @param value The severity of the incident
     */
    @JvmName("hdmmuvjbgibqiwra")
    public fun severity(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IncidentSeverity>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.severity = mapped
    }

    /**
     * @param value The severity of the incident
     */
    @JvmName("antrqpccsyyaikpq")
    public fun severity(`value`: IncidentSeverity) {
        val toBeMapped = Either.ofRight<String, IncidentSeverity>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.severity = mapped
    }

    /**
     * @param value The title of the incident
     */
    @JvmName("wbhbotvcnmthjyqy")
    public suspend fun title(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.title = mapped
    }

    internal fun build(): IncidentInfoArgs = IncidentInfoArgs(
        incidentId = incidentId,
        relationName = relationName,
        severity = severity,
        title = title,
    )
}
