@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.ListGeodataByIpPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enrichmentType Enrichment type
 * @property ipAddress The dotted-decimal or colon-separated string representation of the IP address
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property workspaceName The name of the workspace.
 */
public data class ListGeodataByIpPlainArgs(
    public val enrichmentType: String,
    public val ipAddress: String? = null,
    public val resourceGroupName: String,
    public val workspaceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.ListGeodataByIpPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.inputs.ListGeodataByIpPlainArgs =
        com.pulumi.azurenative.securityinsights.inputs.ListGeodataByIpPlainArgs.builder()
            .enrichmentType(enrichmentType.let({ args0 -> args0 }))
            .ipAddress(ipAddress?.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListGeodataByIpPlainArgs].
 */
@PulumiTagMarker
public class ListGeodataByIpPlainArgsBuilder internal constructor() {
    private var enrichmentType: String? = null

    private var ipAddress: String? = null

    private var resourceGroupName: String? = null

    private var workspaceName: String? = null

    /**
     * @param value Enrichment type
     */
    @JvmName("anpurejcokjoxmrs")
    public suspend fun enrichmentType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.enrichmentType = mapped
    }

    /**
     * @param value The dotted-decimal or colon-separated string representation of the IP address
     */
    @JvmName("hjsmywyalwgyseor")
    public suspend fun ipAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ipAddress = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("dbujyklqagntnlnn")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("jshkiwywvxcfksdh")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): ListGeodataByIpPlainArgs = ListGeodataByIpPlainArgs(
        enrichmentType = enrichmentType ?: throw PulumiNullFieldException("enrichmentType"),
        ipAddress = ipAddress,
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
    )
}
