@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.MetadataAuthorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Publisher or creator of the content item.
 * @property email Email of author contact
 * @property link Link for author/vendor page
 * @property name Name of the author. Company or person.
 */
public data class MetadataAuthorArgs(
    public val email: Output<String>? = null,
    public val link: Output<String>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.MetadataAuthorArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.inputs.MetadataAuthorArgs =
        com.pulumi.azurenative.securityinsights.inputs.MetadataAuthorArgs.builder()
            .email(email?.applyValue({ args0 -> args0 }))
            .link(link?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MetadataAuthorArgs].
 */
@PulumiTagMarker
public class MetadataAuthorArgsBuilder internal constructor() {
    private var email: Output<String>? = null

    private var link: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value Email of author contact
     */
    @JvmName("eatplxexbkyapqyd")
    public suspend fun email(`value`: Output<String>) {
        this.email = value
    }

    /**
     * @param value Link for author/vendor page
     */
    @JvmName("wvsvvrsxrvmiewhb")
    public suspend fun link(`value`: Output<String>) {
        this.link = value
    }

    /**
     * @param value Name of the author. Company or person.
     */
    @JvmName("ctpdyofcgkqpmyry")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Email of author contact
     */
    @JvmName("vpsgxrybnmghrydb")
    public suspend fun email(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.email = mapped
    }

    /**
     * @param value Link for author/vendor page
     */
    @JvmName("gwtxtvricgfrqhsc")
    public suspend fun link(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.link = mapped
    }

    /**
     * @param value Name of the author. Company or person.
     */
    @JvmName("tvcwddrhpwyomqxj")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): MetadataAuthorArgs = MetadataAuthorArgs(
        email = email,
        link = link,
        name = name,
    )
}
