@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.MetadataDependenciesArgs.builder
import com.pulumi.azurenative.securityinsights.kotlin.enums.Kind
import com.pulumi.azurenative.securityinsights.kotlin.enums.Operator
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Dependencies for the content item, what other content items it requires to work.  Can describe more complex dependencies using a recursive/nested structure. For a single dependency an id/kind/version can be supplied or operator/criteria for complex dependencies.
 * @property contentId Id of the content item we depend on
 * @property criteria This is the list of dependencies we must fulfill, according to the AND/OR operator
 * @property kind Type of the content item we depend on
 * @property name Name of the content item
 * @property operator Operator used for list of dependencies in criteria array.
 * @property version Version of the the content item we depend on.  Can be blank, * or missing to indicate any version fulfills the dependency.  If version does not match our defined numeric format then an exact match is required.
 */
public data class MetadataDependenciesArgs(
    public val contentId: Output<String>? = null,
    public val criteria: Output<List<MetadataDependenciesArgs>>? = null,
    public val kind: Output<Either<String, Kind>>? = null,
    public val name: Output<String>? = null,
    public val `operator`: Output<Either<String, Operator>>? = null,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.MetadataDependenciesArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.inputs.MetadataDependenciesArgs =
        com.pulumi.azurenative.securityinsights.inputs.MetadataDependenciesArgs.builder()
            .contentId(contentId?.applyValue({ args0 -> args0 }))
            .criteria(
                criteria?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .kind(
                kind?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .`operator`(
                `operator`?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MetadataDependenciesArgs].
 */
@PulumiTagMarker
public class MetadataDependenciesArgsBuilder internal constructor() {
    private var contentId: Output<String>? = null

    private var criteria: Output<List<MetadataDependenciesArgs>>? = null

    private var kind: Output<Either<String, Kind>>? = null

    private var name: Output<String>? = null

    private var `operator`: Output<Either<String, Operator>>? = null

    private var version: Output<String>? = null

    /**
     * @param value Id of the content item we depend on
     */
    @JvmName("yvoxejlgdppjvjok")
    public suspend fun contentId(`value`: Output<String>) {
        this.contentId = value
    }

    /**
     * @param value This is the list of dependencies we must fulfill, according to the AND/OR operator
     */
    @JvmName("vfhbgbskjqlcyhao")
    public suspend fun criteria(`value`: Output<List<MetadataDependenciesArgs>>) {
        this.criteria = value
    }

    @JvmName("bthnymldlkllpunx")
    public suspend fun criteria(vararg values: Output<MetadataDependenciesArgs>) {
        this.criteria = Output.all(values.asList())
    }

    /**
     * @param values This is the list of dependencies we must fulfill, according to the AND/OR operator
     */
    @JvmName("ecsyqkgofgqtwxof")
    public suspend fun criteria(values: List<Output<MetadataDependenciesArgs>>) {
        this.criteria = Output.all(values)
    }

    /**
     * @param value Type of the content item we depend on
     */
    @JvmName("cyqjoupwreberdcy")
    public suspend fun kind(`value`: Output<Either<String, Kind>>) {
        this.kind = value
    }

    /**
     * @param value Name of the content item
     */
    @JvmName("smguqvrhhoidxkjo")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Operator used for list of dependencies in criteria array.
     */
    @JvmName("jypginpydowllwkc")
    public suspend fun `operator`(`value`: Output<Either<String, Operator>>) {
        this.`operator` = value
    }

    /**
     * @param value Version of the the content item we depend on.  Can be blank, * or missing to indicate any version fulfills the dependency.  If version does not match our defined numeric format then an exact match is required.
     */
    @JvmName("hxetgubymmwalrdj")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value Id of the content item we depend on
     */
    @JvmName("davchluyfksqcchb")
    public suspend fun contentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentId = mapped
    }

    /**
     * @param value This is the list of dependencies we must fulfill, according to the AND/OR operator
     */
    @JvmName("uorncdemascxrmvm")
    public suspend fun criteria(`value`: List<MetadataDependenciesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.criteria = mapped
    }

    /**
     * @param argument This is the list of dependencies we must fulfill, according to the AND/OR operator
     */
    @JvmName("dxdkhclbrveatpks")
    public suspend fun criteria(argument: List<suspend MetadataDependenciesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MetadataDependenciesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.criteria = mapped
    }

    /**
     * @param argument This is the list of dependencies we must fulfill, according to the AND/OR operator
     */
    @JvmName("xvgemdyyoksptmdc")
    public suspend fun criteria(vararg argument: suspend MetadataDependenciesArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            MetadataDependenciesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.criteria = mapped
    }

    /**
     * @param argument This is the list of dependencies we must fulfill, according to the AND/OR operator
     */
    @JvmName("lvbwsafbulmchaiq")
    public suspend fun criteria(argument: suspend MetadataDependenciesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(MetadataDependenciesArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.criteria = mapped
    }

    /**
     * @param values This is the list of dependencies we must fulfill, according to the AND/OR operator
     */
    @JvmName("hjdrxudjanjuffwo")
    public suspend fun criteria(vararg values: MetadataDependenciesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.criteria = mapped
    }

    /**
     * @param value Type of the content item we depend on
     */
    @JvmName("wfaamiwjhicfromi")
    public suspend fun kind(`value`: Either<String, Kind>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Type of the content item we depend on
     */
    @JvmName("irijcstohacxxnof")
    public fun kind(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Kind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Type of the content item we depend on
     */
    @JvmName("fymqchcgxbnoomae")
    public fun kind(`value`: Kind) {
        val toBeMapped = Either.ofRight<String, Kind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Name of the content item
     */
    @JvmName("pwajjwtfecyshncj")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Operator used for list of dependencies in criteria array.
     */
    @JvmName("abcpckywvslpqich")
    public suspend fun `operator`(`value`: Either<String, Operator>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value Operator used for list of dependencies in criteria array.
     */
    @JvmName("hnogpnfmvmrgdtnq")
    public fun `operator`(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Operator>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value Operator used for list of dependencies in criteria array.
     */
    @JvmName("yqhpmihurgprpxuf")
    public fun `operator`(`value`: Operator) {
        val toBeMapped = Either.ofRight<String, Operator>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value Version of the the content item we depend on.  Can be blank, * or missing to indicate any version fulfills the dependency.  If version does not match our defined numeric format then an exact match is required.
     */
    @JvmName("lnwbwanshkmjsqbo")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): MetadataDependenciesArgs = MetadataDependenciesArgs(
        contentId = contentId,
        criteria = criteria,
        kind = kind,
        name = name,
        `operator` = `operator`,
        version = version,
    )
}
