@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.MetadataSupportArgs.builder
import com.pulumi.azurenative.securityinsights.kotlin.enums.SupportTier
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Support information for the content item.
 * @property email Email of support contact
 * @property link Link for support help, like to support page to open a ticket etc.
 * @property name Name of the support contact. Company or person.
 * @property tier Type of support for content item
 */
public data class MetadataSupportArgs(
    public val email: Output<String>? = null,
    public val link: Output<String>? = null,
    public val name: Output<String>? = null,
    public val tier: Output<Either<String, SupportTier>>,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.MetadataSupportArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.inputs.MetadataSupportArgs =
        com.pulumi.azurenative.securityinsights.inputs.MetadataSupportArgs.builder()
            .email(email?.applyValue({ args0 -> args0 }))
            .link(link?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .tier(
                tier.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [MetadataSupportArgs].
 */
@PulumiTagMarker
public class MetadataSupportArgsBuilder internal constructor() {
    private var email: Output<String>? = null

    private var link: Output<String>? = null

    private var name: Output<String>? = null

    private var tier: Output<Either<String, SupportTier>>? = null

    /**
     * @param value Email of support contact
     */
    @JvmName("hsykgvmbpfbxqhyy")
    public suspend fun email(`value`: Output<String>) {
        this.email = value
    }

    /**
     * @param value Link for support help, like to support page to open a ticket etc.
     */
    @JvmName("oeuepcdhipmaspfy")
    public suspend fun link(`value`: Output<String>) {
        this.link = value
    }

    /**
     * @param value Name of the support contact. Company or person.
     */
    @JvmName("doucqiacwiywkiir")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Type of support for content item
     */
    @JvmName("jcqsaqjhavdwvhfn")
    public suspend fun tier(`value`: Output<Either<String, SupportTier>>) {
        this.tier = value
    }

    /**
     * @param value Email of support contact
     */
    @JvmName("yxfrrllntmqsrqmo")
    public suspend fun email(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.email = mapped
    }

    /**
     * @param value Link for support help, like to support page to open a ticket etc.
     */
    @JvmName("rcjyqumrsxjpfwvt")
    public suspend fun link(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.link = mapped
    }

    /**
     * @param value Name of the support contact. Company or person.
     */
    @JvmName("grqjtnxnicmymbqj")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Type of support for content item
     */
    @JvmName("bwwdywpiihvbxcth")
    public suspend fun tier(`value`: Either<String, SupportTier>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    /**
     * @param value Type of support for content item
     */
    @JvmName("osqfbnfxiknguqpc")
    public fun tier(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SupportTier>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    /**
     * @param value Type of support for content item
     */
    @JvmName("xmwddfylbcdndegt")
    public fun tier(`value`: SupportTier) {
        val toBeMapped = Either.ofRight<String, SupportTier>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    internal fun build(): MetadataSupportArgs = MetadataSupportArgs(
        email = email,
        link = link,
        name = name,
        tier = tier ?: throw PulumiNullFieldException("tier"),
    )
}
