@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.PropertyArrayChangedConditionPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Describes an automation rule condition that evaluates an array property's value change
 * @property conditionProperties
 * @property conditionType
 * Expected value is 'PropertyArrayChanged'.
 */
public data class PropertyArrayChangedConditionPropertiesArgs(
    public val conditionProperties: Output<AutomationRulePropertyArrayChangedValuesConditionArgs>? =
        null,
    public val conditionType: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.PropertyArrayChangedConditionPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.inputs.PropertyArrayChangedConditionPropertiesArgs =
        com.pulumi.azurenative.securityinsights.inputs.PropertyArrayChangedConditionPropertiesArgs.builder()
            .conditionProperties(
                conditionProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .conditionType(conditionType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PropertyArrayChangedConditionPropertiesArgs].
 */
@PulumiTagMarker
public class PropertyArrayChangedConditionPropertiesArgsBuilder internal constructor() {
    private var conditionProperties: Output<AutomationRulePropertyArrayChangedValuesConditionArgs>? =
        null

    private var conditionType: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("dnsbprcdvwxehmjd")
    public suspend fun conditionProperties(`value`: Output<AutomationRulePropertyArrayChangedValuesConditionArgs>) {
        this.conditionProperties = value
    }

    /**
     * @param value
     * Expected value is 'PropertyArrayChanged'.
     */
    @JvmName("sdfgehmdtcyuhdph")
    public suspend fun conditionType(`value`: Output<String>) {
        this.conditionType = value
    }

    /**
     * @param value
     */
    @JvmName("eesyaqfjkmjahxls")
    public suspend fun conditionProperties(`value`: AutomationRulePropertyArrayChangedValuesConditionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.conditionProperties = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ceefiixboxajwoci")
    public suspend fun conditionProperties(argument: suspend AutomationRulePropertyArrayChangedValuesConditionArgsBuilder.() -> Unit) {
        val toBeMapped = AutomationRulePropertyArrayChangedValuesConditionArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.conditionProperties = mapped
    }

    /**
     * @param value
     * Expected value is 'PropertyArrayChanged'.
     */
    @JvmName("hrhcnlqkjabiepmg")
    public suspend fun conditionType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.conditionType = mapped
    }

    internal fun build(): PropertyArrayChangedConditionPropertiesArgs =
        PropertyArrayChangedConditionPropertiesArgs(
            conditionProperties = conditionProperties,
            conditionType = conditionType ?: throw PulumiNullFieldException("conditionType"),
        )
}
