@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.PropertyConditionPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Describes an automation rule condition that evaluates a property's value
 * @property conditionProperties
 * @property conditionType
 * Expected value is 'Property'.
 */
public data class PropertyConditionPropertiesArgs(
    public val conditionProperties: Output<AutomationRulePropertyValuesConditionArgs>? = null,
    public val conditionType: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.PropertyConditionPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.inputs.PropertyConditionPropertiesArgs =
        com.pulumi.azurenative.securityinsights.inputs.PropertyConditionPropertiesArgs.builder()
            .conditionProperties(
                conditionProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .conditionType(conditionType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PropertyConditionPropertiesArgs].
 */
@PulumiTagMarker
public class PropertyConditionPropertiesArgsBuilder internal constructor() {
    private var conditionProperties: Output<AutomationRulePropertyValuesConditionArgs>? = null

    private var conditionType: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("douxbimcompdcowd")
    public suspend fun conditionProperties(`value`: Output<AutomationRulePropertyValuesConditionArgs>) {
        this.conditionProperties = value
    }

    /**
     * @param value
     * Expected value is 'Property'.
     */
    @JvmName("fhjwsxpgubgowotg")
    public suspend fun conditionType(`value`: Output<String>) {
        this.conditionType = value
    }

    /**
     * @param value
     */
    @JvmName("ylceqagyosjyasym")
    public suspend fun conditionProperties(`value`: AutomationRulePropertyValuesConditionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.conditionProperties = mapped
    }

    /**
     * @param argument
     */
    @JvmName("rgktfeucvfdqepjo")
    public suspend fun conditionProperties(argument: suspend AutomationRulePropertyValuesConditionArgsBuilder.() -> Unit) {
        val toBeMapped = AutomationRulePropertyValuesConditionArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.conditionProperties = mapped
    }

    /**
     * @param value
     * Expected value is 'Property'.
     */
    @JvmName("qdbracdxosidkpew")
    public suspend fun conditionType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.conditionType = mapped
    }

    internal fun build(): PropertyConditionPropertiesArgs = PropertyConditionPropertiesArgs(
        conditionProperties = conditionProperties,
        conditionType = conditionType ?: throw PulumiNullFieldException("conditionType"),
    )
}
