@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.RepositoryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * metadata of a repository.
 * @property branch Branch name of repository.
 * @property deploymentLogsUrl Url to access repository action logs.
 * @property displayUrl Display url of repository.
 * @property pathMapping Dictionary of source control content type and path mapping.
 * @property url Url of repository.
 */
public data class RepositoryArgs(
    public val branch: Output<String>? = null,
    public val deploymentLogsUrl: Output<String>? = null,
    public val displayUrl: Output<String>? = null,
    public val pathMapping: Output<List<ContentPathMapArgs>>? = null,
    public val url: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.RepositoryArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.inputs.RepositoryArgs =
        com.pulumi.azurenative.securityinsights.inputs.RepositoryArgs.builder()
            .branch(branch?.applyValue({ args0 -> args0 }))
            .deploymentLogsUrl(deploymentLogsUrl?.applyValue({ args0 -> args0 }))
            .displayUrl(displayUrl?.applyValue({ args0 -> args0 }))
            .pathMapping(
                pathMapping?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .url(url?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RepositoryArgs].
 */
@PulumiTagMarker
public class RepositoryArgsBuilder internal constructor() {
    private var branch: Output<String>? = null

    private var deploymentLogsUrl: Output<String>? = null

    private var displayUrl: Output<String>? = null

    private var pathMapping: Output<List<ContentPathMapArgs>>? = null

    private var url: Output<String>? = null

    /**
     * @param value Branch name of repository.
     */
    @JvmName("rboqshmqcltwjyop")
    public suspend fun branch(`value`: Output<String>) {
        this.branch = value
    }

    /**
     * @param value Url to access repository action logs.
     */
    @JvmName("snjtcbueotfwnaqj")
    public suspend fun deploymentLogsUrl(`value`: Output<String>) {
        this.deploymentLogsUrl = value
    }

    /**
     * @param value Display url of repository.
     */
    @JvmName("lxaccjuencolyfgu")
    public suspend fun displayUrl(`value`: Output<String>) {
        this.displayUrl = value
    }

    /**
     * @param value Dictionary of source control content type and path mapping.
     */
    @JvmName("bremxsxxfdevtedc")
    public suspend fun pathMapping(`value`: Output<List<ContentPathMapArgs>>) {
        this.pathMapping = value
    }

    @JvmName("bkynvwcodgeyogss")
    public suspend fun pathMapping(vararg values: Output<ContentPathMapArgs>) {
        this.pathMapping = Output.all(values.asList())
    }

    /**
     * @param values Dictionary of source control content type and path mapping.
     */
    @JvmName("nywyatcggfiyjtuo")
    public suspend fun pathMapping(values: List<Output<ContentPathMapArgs>>) {
        this.pathMapping = Output.all(values)
    }

    /**
     * @param value Url of repository.
     */
    @JvmName("mvsojuwsgscffotp")
    public suspend fun url(`value`: Output<String>) {
        this.url = value
    }

    /**
     * @param value Branch name of repository.
     */
    @JvmName("ilkcenpwgupgvtin")
    public suspend fun branch(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.branch = mapped
    }

    /**
     * @param value Url to access repository action logs.
     */
    @JvmName("rxsmnbosewtmtllc")
    public suspend fun deploymentLogsUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentLogsUrl = mapped
    }

    /**
     * @param value Display url of repository.
     */
    @JvmName("vnuoocnpyjvjeomj")
    public suspend fun displayUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayUrl = mapped
    }

    /**
     * @param value Dictionary of source control content type and path mapping.
     */
    @JvmName("ptnlhgwxuunctene")
    public suspend fun pathMapping(`value`: List<ContentPathMapArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pathMapping = mapped
    }

    /**
     * @param argument Dictionary of source control content type and path mapping.
     */
    @JvmName("dgvjxyoorigqyhbl")
    public suspend fun pathMapping(argument: List<suspend ContentPathMapArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ContentPathMapArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.pathMapping = mapped
    }

    /**
     * @param argument Dictionary of source control content type and path mapping.
     */
    @JvmName("acijvrderygqbcfs")
    public suspend fun pathMapping(vararg argument: suspend ContentPathMapArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ContentPathMapArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.pathMapping = mapped
    }

    /**
     * @param argument Dictionary of source control content type and path mapping.
     */
    @JvmName("asevhvxaujtewney")
    public suspend fun pathMapping(argument: suspend ContentPathMapArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ContentPathMapArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.pathMapping = mapped
    }

    /**
     * @param values Dictionary of source control content type and path mapping.
     */
    @JvmName("ayevdguddwfajfmu")
    public suspend fun pathMapping(vararg values: ContentPathMapArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.pathMapping = mapped
    }

    /**
     * @param value Url of repository.
     */
    @JvmName("jlirnvcyysoetimk")
    public suspend fun url(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.url = mapped
    }

    internal fun build(): RepositoryArgs = RepositoryArgs(
        branch = branch,
        deploymentLogsUrl = deploymentLogsUrl,
        displayUrl = displayUrl,
        pathMapping = pathMapping,
        url = url,
    )
}
