@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.inputs

import com.pulumi.azurenative.securityinsights.inputs.WebhookArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Detail about the webhook object.
 * @property rotateWebhookSecret A flag to instruct the backend service to rotate webhook secret.
 * @property webhookId Unique identifier for the webhook.
 * @property webhookSecretUpdateTime Time when the webhook secret was updated.
 * @property webhookUrl URL that gets invoked by the webhook.
 */
public data class WebhookArgs(
    public val rotateWebhookSecret: Output<Boolean>? = null,
    public val webhookId: Output<String>? = null,
    public val webhookSecretUpdateTime: Output<String>? = null,
    public val webhookUrl: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.securityinsights.inputs.WebhookArgs> {
    override fun toJava(): com.pulumi.azurenative.securityinsights.inputs.WebhookArgs =
        com.pulumi.azurenative.securityinsights.inputs.WebhookArgs.builder()
            .rotateWebhookSecret(rotateWebhookSecret?.applyValue({ args0 -> args0 }))
            .webhookId(webhookId?.applyValue({ args0 -> args0 }))
            .webhookSecretUpdateTime(webhookSecretUpdateTime?.applyValue({ args0 -> args0 }))
            .webhookUrl(webhookUrl?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebhookArgs].
 */
@PulumiTagMarker
public class WebhookArgsBuilder internal constructor() {
    private var rotateWebhookSecret: Output<Boolean>? = null

    private var webhookId: Output<String>? = null

    private var webhookSecretUpdateTime: Output<String>? = null

    private var webhookUrl: Output<String>? = null

    /**
     * @param value A flag to instruct the backend service to rotate webhook secret.
     */
    @JvmName("qlsjiywqdqemkrup")
    public suspend fun rotateWebhookSecret(`value`: Output<Boolean>) {
        this.rotateWebhookSecret = value
    }

    /**
     * @param value Unique identifier for the webhook.
     */
    @JvmName("ruudywbkkhihbsap")
    public suspend fun webhookId(`value`: Output<String>) {
        this.webhookId = value
    }

    /**
     * @param value Time when the webhook secret was updated.
     */
    @JvmName("uilhwfuulkwdbfrd")
    public suspend fun webhookSecretUpdateTime(`value`: Output<String>) {
        this.webhookSecretUpdateTime = value
    }

    /**
     * @param value URL that gets invoked by the webhook.
     */
    @JvmName("laindafdyxdgfyjs")
    public suspend fun webhookUrl(`value`: Output<String>) {
        this.webhookUrl = value
    }

    /**
     * @param value A flag to instruct the backend service to rotate webhook secret.
     */
    @JvmName("sbwrlxllxtuitwoe")
    public suspend fun rotateWebhookSecret(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rotateWebhookSecret = mapped
    }

    /**
     * @param value Unique identifier for the webhook.
     */
    @JvmName("eblaenlihdyityay")
    public suspend fun webhookId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.webhookId = mapped
    }

    /**
     * @param value Time when the webhook secret was updated.
     */
    @JvmName("vsjtpldsjpbxdpqy")
    public suspend fun webhookSecretUpdateTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.webhookSecretUpdateTime = mapped
    }

    /**
     * @param value URL that gets invoked by the webhook.
     */
    @JvmName("fxkbpnlofexedugx")
    public suspend fun webhookUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.webhookUrl = mapped
    }

    internal fun build(): WebhookArgs = WebhookArgs(
        rotateWebhookSecret = rotateWebhookSecret,
        webhookId = webhookId,
        webhookSecretUpdateTime = webhookSecretUpdateTime,
        webhookUrl = webhookUrl,
    )
}
