@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A single alert property mapping to override
 * @property alertProperty The V3 alert property
 * @property value the column name to use to override this property
 */
public data class AlertPropertyMappingResponse(
    public val alertProperty: String? = null,
    public val `value`: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.AlertPropertyMappingResponse): AlertPropertyMappingResponse = AlertPropertyMappingResponse(
            alertProperty = javaType.alertProperty().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
        )
    }
}
