@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Represents anomaly timeline item.
 * @property azureResourceId The anomaly azure resource id.
 * @property description The anomaly description.
 * @property displayName The anomaly name.
 * @property endTimeUtc The anomaly end time.
 * @property intent The intent of the anomaly.
 * @property kind The entity query kind
 * Expected value is 'Anomaly'.
 * @property productName The anomaly product name.
 * @property reasons The reasons that cause the anomaly.
 * @property startTimeUtc The anomaly start time.
 * @property techniques The techniques of the anomaly.
 * @property timeGenerated The anomaly generated time.
 * @property vendor The name of the anomaly vendor.
 */
public data class AnomalyTimelineItemResponse(
    public val azureResourceId: String,
    public val description: String? = null,
    public val displayName: String,
    public val endTimeUtc: String,
    public val intent: String? = null,
    public val kind: String,
    public val productName: String? = null,
    public val reasons: List<String>? = null,
    public val startTimeUtc: String,
    public val techniques: List<String>? = null,
    public val timeGenerated: String,
    public val vendor: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.AnomalyTimelineItemResponse): AnomalyTimelineItemResponse = AnomalyTimelineItemResponse(
            azureResourceId = javaType.azureResourceId(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName(),
            endTimeUtc = javaType.endTimeUtc(),
            intent = javaType.intent().map({ args0 -> args0 }).orElse(null),
            kind = javaType.kind(),
            productName = javaType.productName().map({ args0 -> args0 }).orElse(null),
            reasons = javaType.reasons().map({ args0 -> args0 }),
            startTimeUtc = javaType.startTimeUtc(),
            techniques = javaType.techniques().map({ args0 -> args0 }),
            timeGenerated = javaType.timeGenerated(),
            vendor = javaType.vendor().map({ args0 -> args0 }).orElse(null),
        )
    }
}
