@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Describes an automation rule action to run a playbook
 * @property actionConfiguration
 * @property actionType The type of the automation rule action.
 * Expected value is 'RunPlaybook'.
 * @property order
 */
public data class AutomationRuleRunPlaybookActionResponse(
    public val actionConfiguration: PlaybookActionPropertiesResponse? = null,
    public val actionType: String,
    public val order: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.AutomationRuleRunPlaybookActionResponse): AutomationRuleRunPlaybookActionResponse = AutomationRuleRunPlaybookActionResponse(
            actionConfiguration = javaType.actionConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.PlaybookActionPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            actionType = javaType.actionType(),
            order = javaType.order(),
        )
    }
}
