@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Resources created in Azure DevOps repository.
 * @property pipelineId Id of the pipeline created for the source-control.
 * @property serviceConnectionId Id of the service-connection created for the source-control.
 */
public data class AzureDevOpsResourceInfoResponse(
    public val pipelineId: String? = null,
    public val serviceConnectionId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.AzureDevOpsResourceInfoResponse): AzureDevOpsResourceInfoResponse = AzureDevOpsResourceInfoResponse(
            pipelineId = javaType.pipelineId().map({ args0 -> args0 }).orElse(null),
            serviceConnectionId = javaType.serviceConnectionId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
