@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Information on the client (user or application) that made some action
 * @property email The email of the client.
 * @property name The name of the client.
 * @property objectId The object id of the client.
 * @property userPrincipalName The user principal name of the client.
 */
public data class ClientInfoResponse(
    public val email: String? = null,
    public val name: String? = null,
    public val objectId: String? = null,
    public val userPrincipalName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.ClientInfoResponse): ClientInfoResponse = ClientInfoResponse(
            email = javaType.email().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            objectId = javaType.objectId().map({ args0 -> args0 }).orElse(null),
            userPrincipalName = javaType.userPrincipalName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
