@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The data type which is created by the connector,
 * including a query indicated when was the last time that data type was received in the workspace.
 * @property lastDataReceivedQuery Gets or sets the query to indicate when relevant data was last received in the workspace.
 * @property name Gets or sets the name of the data type to show in the graph.
 */
public data class ConnectorDataTypeResponse(
    public val lastDataReceivedQuery: String,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.ConnectorDataTypeResponse): ConnectorDataTypeResponse = ConnectorDataTypeResponse(
            lastDataReceivedQuery = javaType.lastDataReceivedQuery(),
            name = javaType.name(),
        )
    }
}
