@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The required Permissions for the connector.
 * @property customs Gets or sets the customs permissions required for the user to create connections.
 * @property licenses Gets or sets the required licenses for the user to create connections.
 * @property resourceProvider Gets or sets the resource provider permissions required for the user to create connections.
 * @property tenant Gets or sets the required tenant permissions for the connector.
 */
public data class ConnectorDefinitionsPermissionsResponse(
    public val customs: List<CustomPermissionDetailsResponse>? = null,
    public val licenses: List<String>? = null,
    public val resourceProvider: List<ConnectorDefinitionsResourceProviderResponse>? = null,
    public val tenant: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.ConnectorDefinitionsPermissionsResponse): ConnectorDefinitionsPermissionsResponse = ConnectorDefinitionsPermissionsResponse(
            customs = javaType.customs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.CustomPermissionDetailsResponse.Companion.toKotlin(args0)
                })
            }),
            licenses = javaType.licenses().map({ args0 -> args0 }),
            resourceProvider = javaType.resourceProvider().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.ConnectorDefinitionsResourceProviderResponse.Companion.toKotlin(args0)
                })
            }),
            tenant = javaType.tenant().map({ args0 -> args0 }),
        )
    }
}
