@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The mapping of content type to a repo path.
 * @property contentType Content type.
 * @property path The path to the content.
 */
public data class ContentPathMapResponse(
    public val contentType: String? = null,
    public val path: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.ContentPathMapResponse): ContentPathMapResponse = ContentPathMapResponse(
            contentType = javaType.contentType().map({ args0 -> args0 }).orElse(null),
            path = javaType.path().map({ args0 -> args0 }).orElse(null),
        )
    }
}
