@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The UiConfig for 'Customizable' connector definition kind.
 * @property templateSpecName Gets or sets the template name. The template includes ARM templates that can be created by the connector, usually it will be the dataConnectors ARM templates.
 * @property templateSpecVersion Gets or sets the template version.
 */
public data class CustomizableConnectionsConfigResponse(
    public val templateSpecName: String,
    public val templateSpecVersion: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.CustomizableConnectionsConfigResponse): CustomizableConnectionsConfigResponse = CustomizableConnectionsConfigResponse(
            templateSpecName = javaType.templateSpecName(),
            templateSpecVersion = javaType.templateSpecVersion(),
        )
    }
}
