@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Description about a deployment.
 * @property deploymentId Deployment identifier.
 * @property deploymentLogsUrl Url to access repository action logs.
 * @property deploymentResult The outcome of the deployment.
 * @property deploymentState Current status of the deployment.
 * @property deploymentTime The time when the deployment finished.
 */
public data class DeploymentResponse(
    public val deploymentId: String? = null,
    public val deploymentLogsUrl: String? = null,
    public val deploymentResult: String? = null,
    public val deploymentState: String? = null,
    public val deploymentTime: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.DeploymentResponse): DeploymentResponse = DeploymentResponse(
            deploymentId = javaType.deploymentId().map({ args0 -> args0 }).orElse(null),
            deploymentLogsUrl = javaType.deploymentLogsUrl().map({ args0 -> args0 }).orElse(null),
            deploymentResult = javaType.deploymentResult().map({ args0 -> args0 }).orElse(null),
            deploymentState = javaType.deploymentState().map({ args0 -> args0 }).orElse(null),
            deploymentTime = javaType.deploymentTime().map({ args0 -> args0 }).orElse(null),
        )
    }
}
