@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * An individual contact associated with this domain
 * @property city The city for this contact
 * @property country The country for this contact
 * @property email The email address for this contact
 * @property fax The fax number for this contact
 * @property name The name of this contact
 * @property org The organization for this contact
 * @property phone The phone number for this contact
 * @property postal The postal code for this contact
 * @property state The state for this contact
 * @property street A list describing the street address for this contact
 */
public data class EnrichmentDomainWhoisContactResponse(
    public val city: String? = null,
    public val country: String? = null,
    public val email: String? = null,
    public val fax: String? = null,
    public val name: String? = null,
    public val org: String? = null,
    public val phone: String? = null,
    public val postal: String? = null,
    public val state: String? = null,
    public val street: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.EnrichmentDomainWhoisContactResponse): EnrichmentDomainWhoisContactResponse = EnrichmentDomainWhoisContactResponse(
            city = javaType.city().map({ args0 -> args0 }).orElse(null),
            country = javaType.country().map({ args0 -> args0 }).orElse(null),
            email = javaType.email().map({ args0 -> args0 }).orElse(null),
            fax = javaType.fax().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            org = javaType.org().map({ args0 -> args0 }).orElse(null),
            phone = javaType.phone().map({ args0 -> args0 }).orElse(null),
            postal = javaType.postal().map({ args0 -> args0 }).orElse(null),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
            street = javaType.street().map({ args0 -> args0 }),
        )
    }
}
