@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.Suppress

/**
 * The set of contacts associated with this domain
 * @property admin The admin contact for this whois record
 * @property billing The billing contact for this whois record
 * @property registrant The registrant contact for this whois record
 * @property tech The technical contact for this whois record
 */
public data class EnrichmentDomainWhoisContactsResponse(
    public val admin: EnrichmentDomainWhoisContactResponse? = null,
    public val billing: EnrichmentDomainWhoisContactResponse? = null,
    public val registrant: EnrichmentDomainWhoisContactResponse? = null,
    public val tech: EnrichmentDomainWhoisContactResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.EnrichmentDomainWhoisContactsResponse): EnrichmentDomainWhoisContactsResponse = EnrichmentDomainWhoisContactsResponse(
            admin = javaType.admin().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.EnrichmentDomainWhoisContactResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            billing = javaType.billing().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.EnrichmentDomainWhoisContactResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            registrant = javaType.registrant().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.EnrichmentDomainWhoisContactResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tech = javaType.tech().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.EnrichmentDomainWhoisContactResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
