@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The whois record for a given domain
 * @property contacts The set of contacts associated with this domain
 * @property nameServers A list of name servers associated with this domain
 * @property registrar The registrar associated with this domain
 * @property statuses The set of status flags for this whois record
 */
public data class EnrichmentDomainWhoisDetailsResponse(
    public val contacts: EnrichmentDomainWhoisContactsResponse? = null,
    public val nameServers: List<String>? = null,
    public val registrar: EnrichmentDomainWhoisRegistrarDetailsResponse? = null,
    public val statuses: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.EnrichmentDomainWhoisDetailsResponse): EnrichmentDomainWhoisDetailsResponse = EnrichmentDomainWhoisDetailsResponse(
            contacts = javaType.contacts().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.EnrichmentDomainWhoisContactsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            nameServers = javaType.nameServers().map({ args0 -> args0 }),
            registrar = javaType.registrar().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.EnrichmentDomainWhoisRegistrarDetailsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            statuses = javaType.statuses().map({ args0 -> args0 }),
        )
    }
}
