@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The registrar associated with this domain
 * @property abuseContactEmail This registrar's abuse contact email
 * @property abuseContactPhone This registrar's abuse contact phone number
 * @property ianaId This registrar's Internet Assigned Numbers Authority id
 * @property name The name of this registrar
 * @property url This registrar's URL
 * @property whoisServer The hostname of this registrar's whois server
 */
public data class EnrichmentDomainWhoisRegistrarDetailsResponse(
    public val abuseContactEmail: String? = null,
    public val abuseContactPhone: String? = null,
    public val ianaId: String? = null,
    public val name: String? = null,
    public val url: String? = null,
    public val whoisServer: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.EnrichmentDomainWhoisRegistrarDetailsResponse): EnrichmentDomainWhoisRegistrarDetailsResponse =
            EnrichmentDomainWhoisRegistrarDetailsResponse(
                abuseContactEmail = javaType.abuseContactEmail().map({ args0 -> args0 }).orElse(null),
                abuseContactPhone = javaType.abuseContactPhone().map({ args0 -> args0 }).orElse(null),
                ianaId = javaType.ianaId().map({ args0 -> args0 }).orElse(null),
                name = javaType.name().map({ args0 -> args0 }).orElse(null),
                url = javaType.url().map({ args0 -> args0 }).orElse(null),
                whoisServer = javaType.whoisServer().map({ args0 -> args0 }).orElse(null),
            )
    }
}
