@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The Time interval that the query actually executed on.
 * @property endTime Insight query end time
 * @property startTime Insight query start time
 */
public data class EntityInsightItemResponseQueryTimeInterval(
    public val endTime: String? = null,
    public val startTime: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.EntityInsightItemResponseQueryTimeInterval): EntityInsightItemResponseQueryTimeInterval = EntityInsightItemResponseQueryTimeInterval(
            endTime = javaType.endTime().map({ args0 -> args0 }).orElse(null),
            startTime = javaType.startTime().map({ args0 -> args0 }).orElse(null),
        )
    }
}
