@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Represents ASC (Azure Security Center) data connector.
 * @property dataTypes The available data types for the connector.
 * @property etag Etag of the azure resource
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property kind The kind of the data connector
 * Expected value is 'AzureSecurityCenter'.
 * @property name The name of the resource
 * @property subscriptionId The subscription id to connect to, and get the data from.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetASCDataConnectorResult(
    public val dataTypes: AlertsDataTypeOfDataConnectorResponse? = null,
    public val etag: String? = null,
    public val id: String,
    public val kind: String,
    public val name: String,
    public val subscriptionId: String? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.GetASCDataConnectorResult): GetASCDataConnectorResult = GetASCDataConnectorResult(
            dataTypes = javaType.dataTypes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.AlertsDataTypeOfDataConnectorResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            kind = javaType.kind(),
            name = javaType.name(),
            subscriptionId = javaType.subscriptionId().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
