@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Represents Activity entity query.
 * @property content The entity query content to display in timeline
 * @property createdTimeUtc The time the activity was created
 * @property description The entity query description
 * @property enabled Determines whether this activity is enabled or disabled.
 * @property entitiesFilter The query applied only to entities matching to all filters
 * @property etag Etag of the azure resource
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property inputEntityType The type of the query's source entity
 * @property kind The kind of the entity query
 * Expected value is 'Activity'.
 * @property lastModifiedTimeUtc The last time the activity was updated
 * @property name The name of the resource
 * @property queryDefinitions The Activity query definitions
 * @property requiredInputFieldsSets List of the fields of the source entity that are required to run the query
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property templateName The template id this activity was created from
 * @property title The entity query title
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetActivityCustomEntityQueryResult(
    public val content: String? = null,
    public val createdTimeUtc: String,
    public val description: String? = null,
    public val enabled: Boolean? = null,
    public val entitiesFilter: Map<String, List<String>>? = null,
    public val etag: String? = null,
    public val id: String,
    public val inputEntityType: String? = null,
    public val kind: String,
    public val lastModifiedTimeUtc: String,
    public val name: String,
    public val queryDefinitions: ActivityEntityQueriesPropertiesResponseQueryDefinitions? = null,
    public val requiredInputFieldsSets: List<List<String>>? = null,
    public val systemData: SystemDataResponse,
    public val templateName: String? = null,
    public val title: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.GetActivityCustomEntityQueryResult): GetActivityCustomEntityQueryResult = GetActivityCustomEntityQueryResult(
            content = javaType.content().map({ args0 -> args0 }).orElse(null),
            createdTimeUtc = javaType.createdTimeUtc(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            entitiesFilter = javaType.entitiesFilter().map({ args0 ->
                args0.key.to(
                    args0.value.map({ args0 ->
                        args0
                    }),
                )
            }).toMap(),
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            inputEntityType = javaType.inputEntityType().map({ args0 -> args0 }).orElse(null),
            kind = javaType.kind(),
            lastModifiedTimeUtc = javaType.lastModifiedTimeUtc(),
            name = javaType.name(),
            queryDefinitions = javaType.queryDefinitions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.ActivityEntityQueriesPropertiesResponseQueryDefinitions.Companion.toKotlin(args0)
                })
            }).orElse(null),
            requiredInputFieldsSets = javaType.requiredInputFieldsSets().map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            templateName = javaType.templateName().map({ args0 -> args0 }).orElse(null),
            title = javaType.title().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
