@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Connector definition for kind 'Customizable'.
 * @property connectionsConfig The UiConfig for 'Customizable' connector definition kind.
 * @property connectorUiConfig The UiConfig for 'Customizable' connector definition kind.
 * @property createdTimeUtc Gets or sets the connector definition created date in UTC format.
 * @property etag Etag of the azure resource
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property kind The kind of the data connector definitions
 * Expected value is 'Customizable'.
 * @property lastModifiedUtc Gets or sets the connector definition last modified date in UTC format.
 * @property name The name of the resource
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetCustomizableConnectorDefinitionResult(
    public val connectionsConfig: CustomizableConnectionsConfigResponse? = null,
    public val connectorUiConfig: CustomizableConnectorUiConfigResponse,
    public val createdTimeUtc: String? = null,
    public val etag: String? = null,
    public val id: String,
    public val kind: String,
    public val lastModifiedUtc: String? = null,
    public val name: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.GetCustomizableConnectorDefinitionResult): GetCustomizableConnectorDefinitionResult = GetCustomizableConnectorDefinitionResult(
            connectionsConfig = javaType.connectionsConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.CustomizableConnectionsConfigResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            connectorUiConfig = javaType.connectorUiConfig().let({ args0 ->
                com.pulumi.azurenative.securityinsights.kotlin.outputs.CustomizableConnectorUiConfigResponse.Companion.toKotlin(args0)
            }),
            createdTimeUtc = javaType.createdTimeUtc().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            kind = javaType.kind(),
            lastModifiedUtc = javaType.lastModifiedUtc().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
