@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * The Get Insights result operation response.
 * @property metaData The metadata from the get insights operation results.
 * @property value The insights result values.
 */
public data class GetEntityInsightsResult(
    public val metaData: GetInsightsResultsMetadataResponse? = null,
    public val `value`: List<EntityInsightItemResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.GetEntityInsightsResult): GetEntityInsightsResult = GetEntityInsightsResult(
            metaData = javaType.metaData().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.GetInsightsResultsMetadataResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            `value` = javaType.`value`().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.EntityInsightItemResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
