@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Represents a file import in Azure Security Insights.
 * @property contentType The content type of this file.
 * @property createdTimeUTC The time the file was imported.
 * @property errorFile Represents the error file (if the import was ingested with errors or failed the validation).
 * @property errorsPreview An ordered list of some of the errors that were encountered during validation.
 * @property filesValidUntilTimeUTC The time the files associated with this import are deleted from the storage account.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property importFile Represents the imported file.
 * @property importValidUntilTimeUTC The time the file import record is soft deleted from the database and history.
 * @property ingestedRecordCount The number of records that have been successfully ingested.
 * @property ingestionMode Describes how to ingest the records in the file.
 * @property name The name of the resource
 * @property source The source for the data in the file.
 * @property state The state of the file import.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property totalRecordCount The number of records in the file.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property validRecordCount The number of records that have passed validation.
 */
public data class GetFileImportResult(
    public val contentType: String,
    public val createdTimeUTC: String,
    public val errorFile: FileMetadataResponse,
    public val errorsPreview: List<ValidationErrorResponse>,
    public val filesValidUntilTimeUTC: String,
    public val id: String,
    public val importFile: FileMetadataResponse,
    public val importValidUntilTimeUTC: String,
    public val ingestedRecordCount: Int,
    public val ingestionMode: String,
    public val name: String,
    public val source: String,
    public val state: String,
    public val systemData: SystemDataResponse,
    public val totalRecordCount: Int,
    public val type: String,
    public val validRecordCount: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.GetFileImportResult): GetFileImportResult = GetFileImportResult(
            contentType = javaType.contentType(),
            createdTimeUTC = javaType.createdTimeUTC(),
            errorFile = javaType.errorFile().let({ args0 ->
                com.pulumi.azurenative.securityinsights.kotlin.outputs.FileMetadataResponse.Companion.toKotlin(args0)
            }),
            errorsPreview = javaType.errorsPreview().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.ValidationErrorResponse.Companion.toKotlin(args0)
                })
            }),
            filesValidUntilTimeUTC = javaType.filesValidUntilTimeUTC(),
            id = javaType.id(),
            importFile = javaType.importFile().let({ args0 ->
                com.pulumi.azurenative.securityinsights.kotlin.outputs.FileMetadataResponse.Companion.toKotlin(args0)
            }),
            importValidUntilTimeUTC = javaType.importValidUntilTimeUTC(),
            ingestedRecordCount = javaType.ingestedRecordCount(),
            ingestionMode = javaType.ingestionMode(),
            name = javaType.name(),
            source = javaType.source(),
            state = javaType.state(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            totalRecordCount = javaType.totalRecordCount(),
            type = javaType.type(),
            validRecordCount = javaType.validRecordCount(),
        )
    }
}
