@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Represents Fusion alert rule.
 * @property alertRuleTemplateName The Name of the alert rule template used to create this rule.
 * @property description The description of the alert rule.
 * @property displayName The display name for alerts created by this alert rule.
 * @property enabled Determines whether this alert rule is enabled or disabled.
 * @property etag Etag of the azure resource
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property kind The kind of the alert rule
 * Expected value is 'Fusion'.
 * @property lastModifiedUtc The last time that this alert has been modified.
 * @property name The name of the resource
 * @property severity The severity for alerts created by this alert rule.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tactics The tactics of the alert rule
 * @property techniques The techniques of the alert rule
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetFusionAlertRuleResult(
    public val alertRuleTemplateName: String,
    public val description: String,
    public val displayName: String,
    public val enabled: Boolean,
    public val etag: String? = null,
    public val id: String,
    public val kind: String,
    public val lastModifiedUtc: String,
    public val name: String,
    public val severity: String,
    public val systemData: SystemDataResponse,
    public val tactics: List<String>,
    public val techniques: List<String>,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.GetFusionAlertRuleResult): GetFusionAlertRuleResult = GetFusionAlertRuleResult(
            alertRuleTemplateName = javaType.alertRuleTemplateName(),
            description = javaType.description(),
            displayName = javaType.displayName(),
            enabled = javaType.enabled(),
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            kind = javaType.kind(),
            lastModifiedUtc = javaType.lastModifiedUtc(),
            name = javaType.name(),
            severity = javaType.severity(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tactics = javaType.tactics().map({ args0 -> args0 }),
            techniques = javaType.techniques().map({ args0 -> args0 }),
            type = javaType.type(),
        )
    }
}
