@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Represents a Hunt Relation in Azure Security Insights.
 * @property etag Etag of the azure resource
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property labels List of labels relevant to this hunt
 * @property name The name of the resource
 * @property relatedResourceId The id of the related resource
 * @property relatedResourceKind The resource that the relation is related to
 * @property relatedResourceName The name of the related resource
 * @property relationType The type of the hunt relation
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetHuntRelationResult(
    public val etag: String? = null,
    public val id: String,
    public val labels: List<String>? = null,
    public val name: String,
    public val relatedResourceId: String,
    public val relatedResourceKind: String,
    public val relatedResourceName: String,
    public val relationType: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.GetHuntRelationResult): GetHuntRelationResult = GetHuntRelationResult(
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            labels = javaType.labels().map({ args0 -> args0 }),
            name = javaType.name(),
            relatedResourceId = javaType.relatedResourceId(),
            relatedResourceKind = javaType.relatedResourceKind(),
            relatedResourceName = javaType.relatedResourceName(),
            relationType = javaType.relationType(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
