@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Represents a Hunt in Azure Security Insights.
 * @property attackTactics A list of mitre attack tactics the hunt is associated with
 * @property attackTechniques A list of a mitre attack techniques the hunt is associated with
 * @property description The description of the hunt
 * @property displayName The display name of the hunt
 * @property etag Etag of the azure resource
 * @property hypothesisStatus The hypothesis status of the hunt.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property labels List of labels relevant to this hunt
 * @property name The name of the resource
 * @property owner Describes a user that the hunt is assigned to
 * @property status The status of the hunt.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetHuntResult(
    public val attackTactics: List<String>? = null,
    public val attackTechniques: List<String>? = null,
    public val description: String,
    public val displayName: String,
    public val etag: String? = null,
    public val hypothesisStatus: String? = null,
    public val id: String,
    public val labels: List<String>? = null,
    public val name: String,
    public val owner: HuntOwnerResponse? = null,
    public val status: String? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.GetHuntResult): GetHuntResult = GetHuntResult(
            attackTactics = javaType.attackTactics().map({ args0 -> args0 }),
            attackTechniques = javaType.attackTechniques().map({ args0 -> args0 }),
            description = javaType.description(),
            displayName = javaType.displayName(),
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            hypothesisStatus = javaType.hypothesisStatus().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            labels = javaType.labels().map({ args0 -> args0 }),
            name = javaType.name(),
            owner = javaType.owner().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.HuntOwnerResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
